/*
 *      REMOVE.CMD SendYes! V2.0 - C.Langanke 1996 - Deinstallation
 *
 *      Syntax: REMOVE.CMD [/?]
 *
 *      Removes all WPS objects which where installed
 *      through INSTALL.CMD of the SendYes! package.
 *
 *      /?  -  display this help text
 */
/* The first comment is used as online help text */

 SIGNAL ON HALT

 TitleLine = STRIP(SUBSTR(SourceLine(2), 3));
 PARSE VAR TitleLine CmdName'.CMD 'Info
 Title     = CmdName Info
 NewLine   = D2C(13)||D2C(10);
 TRUE      = (1 = 1);
 FALSE     = (0 = 1);
  
 /* some OS/2 Error codes */
 ERROR.NO_ERROR          =  0;
 ERROR.ACCESS_DENIED     =  5;
 ERROR.NOT_ENOUGH_MEMORY =  8;
 ERROR.INVALID_DATA      = 13;
 ERROR.NO_MORE_FILES     = 18;
 ERROR.GEN_FAILURE       = 31;
 ERROR.INVALID_PARAMETER = 87;

 /* determine directories */
 InstallDir  = GetCallDir();
 LastSlash   = LASTPOS( '\', InstallDir);
 ProgDir     = LEFT(InstallDir, LastSlash - 1);

 /* NLS file name definitions */
 NLSFileBaseName  = 'SNDYS';

 /* default values */
 NlsMsg.HaltMsg      = 'Interrupted by user.';
 NlsMsg.AbortProgram = 'Program aborted.';
 NlsMsg.Error        =  'error';

 Default.LanguageAbrv = 'ENG';

 /* INI file definitions */
 Ini.FileName         = ProgDir'\SENDYES.INI';
 Ini.AppName          = "SendYes!";
 Ini.KeyName_Language = "Language";

/*
 *      load RexxUtil
 */

 CALL RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
 CALL SysLoadFuncs;
  
 SAY;
 SAY Title
 SAY;

/*
 *      show help
 */

 ARG Parms
 IF (POS('?', Parms) > 0) THEN
 DO
    rc = ShowHelp();
    EXIT(ERROR.NO_ERROR)
 END;

 /* use language specified in INI file if not specified within parameters */ 
 Selected.Language = SysIni( Ini.Filename, Ini.AppName, Ini.KeyName_Language);
 IF (Selected.Language \= 'ERROR:') THEN
    Selected.Language = LEFT(Selected.Language, 3);
 ELSE
    Selected.Language = Default.LanguageAbrv;

 /* select NLS settings */
 MessageFile           = InstallDir'\'NLSFileBaseName''Selected.Language'.MSG';

 /* load messages and object strings */
 rc = LoadMessageFile(MessageFile, FALSE);
 IF (rc \= ERROR.NO_ERROR) THEN
 DO
    SAY CmdName':' NlsMsg.Error': The install message file was not found.'; 
    SAY NlsMsg.AbortProgram;
    EXIT(ERROR.ACCESS_DENIED);
 END;
 ExitKey = RIGHT(NlsMsg.Keys, 1);

/*
 *      check, if folder object is installed
 */

 /* get details about foldder */
 /* parse object details */
 PARSE VAR Objects.1,
        '"'ObjectClass'"',
        '"'ObjectLocation'"',
        '"'ObjectId'"',
        '"'ObjectTitle'"',
        '"'ObjectOption'"',
        '"'ObjectExeName'"',
        '"'ObjectParameters'"',
        '"'ObjectSetup'"'

 /* test, if installed */
 rc = SysSetObjectData(ObjectId, '');
 IF (rc = 0) THEN
 DO
    SAY NlsMsg.NotInstalled;
    SAY NlsMsg.AbortProgram;
    EXIT(ERROR.ACCESS_DENIED);
 END;

/*
 *      ask to deinstall
 */

 SAY;
 IF (\ProceedWith(NlsMsg.Deinstall)) THEN
    SIGNAL HALT;

/*
 *      Now delete all objects
 */

 DO i = Objects.0 TO 1 BY -1
    /* parse object details */
    PARSE VAR Objects.i,
           '"'ObjectClass'"',
           '"'ObjectLocation'"',
           '"'ObjectId'"',
           '"'ObjectTitle'"',
           '"'ObjectOption'"',
           '"'ObjectExeName'"',
           '"'ObjectParameters'"',
           '"'ObjectSetup'"'

    /* destroy object */
    rc = DestroyObject(ObjectId, ObjectTitle);
 END;

 /* success message */
 SAY;
 SAY NlsMsg.DeinstallEnded;

 EXIT(ERROR.NO_ERROR);

/* ------------------------------------------------------------------------- */

HALT:
  SAY NlsMsg.HaltMsg;
  EXIT(ERROR.GEN_FAILURE);

/* ------------------------------------------------------------------------- */
ShowHelp: PROCEDURE EXPOSE ExitMessage

 PARSE SOURCE . . ThisFile

 /* skip header */
 DO i = 1 TO 3
    rc = LINEIN(ThisFile);
 END;

 /* show help */
 DO WHILE (ThisLine \= ' */')
    ThisLine = LINEIN(Thisfile);
    SAY SUBSTR(ThisLine, 7);
 END;

 /* close file */
 rc = LINEOUT(Thisfile);

 RETURN('');

/* ------------------------------------------------------------------------- */
DestroyObject: PROCEDURE EXPOSE NlsMsg. ExitMessage
 PARSE ARG ObjectId, ObjectTitle

 CALL CHAROUT, LEFT(ObjectTitle, 50) NlsMsg.Delete '... ';

 rc = SysDestroyObject(ObjectId);

 IF (rc) THEN
    SAY NlsMsg.Ok
 ELSE
    SAY NlsMsg.Error '!'

 RETURN(rc);
   
/* ------------------------------------------------------------------------- */
LoadMsgString: PROCEDURE EXPOSE ExitMessage
 ARG MsgId, MessageFile

 Message = SysGetMessage(MsgId, MessageFile);
 RETURN(LEFT(Message, LENGTH(Message) - 2));

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE EXPOSE ExitMessage 
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
ProceedWith: PROCEDURE EXPOSE NlsMsg. ExitMessage 
 PARSE ARG Prompt

 ch            = ' ';
 ValidResponse = LEFT(NlsMsg.Keys, 2);
 YesKey        = LEFT(ValidResponse, 1);
 NoKey         = RIGHT(ValidResponse, 1);

 SAY;
 CALL CHAROUT ,Prompt '('YesKey'/'NoKey') '
 DO WHILE (POS(ch, ValidResponse) = 0)
    PULL ch
    ch = TRANSLATE(ch);
    IF (POS(ch, ValidResponse) = 0) THEN BEEP(800, 200);
 END;
 SAY;
 SAY;
 RETURN(ch = YesKey);

/* ========================================================================= */
LoadMessageFile: PROCEDURE EXPOSE ERROR. NlsMsg. Objects. ExitMessage,
                                  InstLanguage InstLanguageAbrv 

 ARG MessageFile, ReadInfoOnly

 /* default values */
 MessageFileIdText = 'SENDYES_MESSAGEFILE';
 DROP(Objects.);
 Objects.  = '';
 Objects.0 = 0;

 /* load MessageIds and YesNo Keys*/
 MessageFileInfo        = LoadMsgString(0, MessageFile)
 PARSE VAR MessageFileInfo MessageFileId InstMsgStart InstObjectsStart InstObjectsEnd NlsMsg.Keys InstLanguage InstLanguageAbrv
 IF (MessageFileIdText \= MessageFileId) THEN
    RETURN(ERROR.INVALID_DATA);

 IF (\ReadInfoOnly) THEN
 DO
    /* load message strings */
    NlsMsg.AbortProgram     = LoadMsgString(InstMsgStart +  0, MessageFile);
    NlsMsg.AlreadyActive    = LoadMsgString(InstMsgStart +  1, MessageFile);
    NlsMsg.HaltMsg          = LoadMsgString(InstMsgStart +  2, MessageFile);
    NlsMsg.Readme           = LoadMsgString(InstMsgStart +  3, MessageFile);
    NlsMsg.Install          = LoadMsgString(InstMsgStart +  4, MessageFile);
    NlsMsg.NLSSelect        = LoadMsgString(InstMsgStart +  5, MessageFile);
    NlsMsg.Exit             = LoadMsgString(InstMsgStart +  6, MessageFile);
    NlsMsg.Ok               = LoadMsgString(InstMsgStart +  7, MessageFile);
    NlsMsg.Error            = LoadMsgString(InstMsgStart +  8, MessageFile);
    NlsMsg.InstallPrompt    = LoadMsgString(InstMsgStart +  9, MessageFile)
    NlsMsg.TargetDirInstall = LoadMsgString(InstMsgStart + 10, MessageFile);
    NlsMsg.TargetDirExists  = LoadMsgString(InstMsgStart + 11, MessageFile);
    NlsMsg.InvalidParm      = LoadMsgString(InstMsgStart + 12, MessageFile);
    NlsMsg.NotExist         = LoadMsgString(InstMsgStart + 13, MessageFile);
    NlsMsg.XcopyFailed      = LoadMsgString(InstMsgStart + 14, MessageFile);
    NlsMsg.DeactivatePrompt = LoadMsgString(InstMsgStart + 15, MessageFile); /**/
    NlsMsg.Deactivated      = LoadMsgString(InstMsgStart + 16, MessageFile); /**/
    NlsMsg.Create           = LoadMsgString(InstMsgStart + 17, MessageFile);
    NlsMsg.Delete           = LoadMsgString(InstMsgStart + 18, MessageFile);
    NlsMsg.Deinstall        = LoadMsgString(InstMsgStart + 19, MessageFile);
    NlsMsg.NotInstalled     = LoadMsgString(InstMsgStart + 20, MessageFile);
    NlsMsg.InstallEnded     = LoadMsgString(InstMsgStart + 21, MessageFile);
    NlsMsg.DeInstallEnded   = LoadMsgString(InstMsgStart + 22, MessageFile);
   
    /* load object strings */
    DO i = InstObjectsStart TO InstObjectsEnd
       n         = Objects.0 + 1;
       Objects.n = LoadMsgString(i, MessageFile);
       Objects.0 = n;
    END;

 END; /* IF (\ReadInfoOnly) */

 RETURN(ERROR.NO_ERROR);

