#include <fcntl.h>
#include <io.h>
#include <iconv.h>
#include <langinfo.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <share.h>
#include <share.h>

// *** IP includes
extern "C" {
#include <TYPES.H>         // Contains data type definitions.
#include <NETINET\IN.H>    // Defines Internet constants and structures.
#include <ARPA\NAMESER.H>  // Contains Internet name server information.
#include <NETDB.H>         // Contains data definitions for socket calls.
#include <RESOLV.H>        // Contains resolver global definitions and variables.
#include <SYS\SOCKET.H>    // Contains data definitions and socket structures.
#include <SYS\UN.H>        // Defines structures for the UNIX interprocess communication domain.
#include <NERRNO.H>        // Defines socket error codes issued for network communication errors.
}
// *** IP includes

int ConnectionPort=110, sockSocket, rc;
char DottedAddr[]="192.168.1.21";
struct sockaddr_in sockAddr;


int readline(char *line, int size, int sock)
{
   int rc, recved;

   recved=-1;
   do
   {
      rc=recv(sock, &line[++recved], 1, 0);
   }
   while (recved+1<size && line[recved]!=0x0a);

   if (recved+1<size)
   {
      recved--;
      line[recved]=0;
   }
   else
   {
     line[recved]=0;
     recved=-1;
   }

   return recved;
}


int strDecodeB64(char* strIn, char *strOut, int *decoded)
{
   char alph[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
   long word, j, i;
   static char bits, bytes[127], *q;


   if (bits==0) for(i=0;alph[i]!=0;i++)
   bytes[alph[i]]=i; else bits=0;

   j=word=i=0;
   while (strIn[i]!=0 && strIn[i]!='=' && strIn[i]!='?')
   {
      word<<=6;
      word|=bytes[strIn[i++]];
      bits++;

      if (bits>3)
      {

         strOut[j++]=(word>>16)&0xff;
         strOut[j++]=(word>>8)&0xff;
         strOut[j++]=word&0xff;

         bits=0;
         word=0;
      }
   }

   switch (bits)
   {
      case 3:strOut[j++]=(word>>10)&0xff; strOut[j++]=(word>>2)&0xff;break;
      case 2:strOut[j++]=(word>>4)&0xff;
   }


*decoded=j;
return i;
}

int sbjDecodeB(char *strOut, char *strIn, int *decoded)
{

return strDecodeB64(strIn, strOut, decoded);
}

int sbjDecodeQ(char *strDecoded, char *strOrig, int *jj)
{
   char strHexHolder[3], code, k;
   int i, j;

   k=strHexHolder[2]=0; // *** end of string...
   i=j=0;

   while(strOrig[i]!='?')
   {
      switch (strOrig[i])
      {
         case '=':k=0;strHexHolder[k++]=strOrig[++i];strHexHolder[k++]=strOrig[++i];i++;
                  sscanf(strHexHolder, "%X", &code);
                  strDecoded[j++]=code;
                  break;
         case '_':strDecoded[j++]=' ';break;
         case '?':i+=2;break;
         default: strDecoded[j++]=strOrig[i++];
      }
   }

*jj=j;
return ++i;
}

char *cpConvert ( char *strIn, char *strOut, char *cpFrom, char *cpTo)
{
   unsigned int strLen;
   char *obuf = strOut, *ibuf=strIn;
   iconv_t  cd;

   cd=iconv_open(cpTo, cpFrom);
   if (cd!=(iconv_t)-1)
   {
      strLen = strlen(strIn);
      iconv( cd, (char const**)&ibuf, &strLen, &obuf, &strLen);
      iconv_close(cd);
   }

return strOut;
}


int GetCP(char *strDest, char *strOrig)
{
   int i,j;

   for (j=0,i=0;strOrig[i]!='?';i++)
      strDest[j++]=strOrig[i];
   strDest[j]=0;

return j;
}

char * sbjDecode(char *strDecoded, char *strOrig)
{
// decode subject and translate CP
   short int wrdEnc=('?'<<8)|'=';
   char CharSet[80], strBuff[80]; // *** according to rfc string size may not exceed 76 chars... so it must work, I hope.
   int i, j, ii, jj;

   strOrig[79]=0; // *** take just 80 very first chars to avoid overflow :)

   for(j=i=0;strOrig[i]!=0;i++)
   {
      if(strOrig[i]=='=' && *(short int*)&strOrig[i]==wrdEnc)
      {
         i+=GetCP(CharSet, &strOrig[++++i]);

// *** parse according to rfc 1252
         ii=0;
         switch (strOrig[++i])
         {
            case 'Q':ii=sbjDecodeQ(&strDecoded[j], &strOrig[++++i], &jj);break;
            case 'B':ii=sbjDecodeB(&strDecoded[j], &strOrig[++++i], &jj);break;
             default:; // !!! indicate error
         }

         cpConvert(&strDecoded[j],  strBuff, CharSet, nl_langinfo(CODESET));
         strcpy(&strDecoded[j], strBuff);
         i+=ii;j+=jj;
      }
      else strDecoded[j++]=strOrig[i];
   }

strDecoded[j]=0;
return strDecoded;
}


void main(char argc, char ** argv)
{
   char LineToSend[1024], ErrorOccured[]="Error occured: %s\n";
   char strDecoded[512], answPos='+';
   int  nums, i, bts, word, wrdSubj=(('j'<<24)|('b'<<16)|('u'<<8)|'s'), wrdFrom=(('m'<<24)|('o'<<16)|('r'<<8)|'f');
   int *ii;


   sockSocket=socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
   if (sockSocket==-1)
   {
      printf("Can't create socket");exit(0);
   }
   else
   {
      memset(&sockAddr, 0, sizeof(sockAddr));
      sockAddr.sin_family=AF_INET;
      sockAddr.sin_port=htons((int)ConnectionPort);
      sockAddr.sin_addr.s_addr=inet_addr(DottedAddr);

      rc=connect(sockSocket, (struct sockaddr*) &sockAddr, sizeof(sockAddr));
      if (rc==-1)
      {
         printf("Socket error occured\n");
      }
      else
      {
   // *** great
         readline(&LineToSend[0], sizeof(LineToSend), sockSocket);
         printf("%s\n", LineToSend);
         if (LineToSend[0]!=answPos) {printf("Error occured\n"); exit(0);}

   // *** USER
         sprintf(LineToSend, "user %s\r\n", argv[1]);
         rc=send(sockSocket, LineToSend, strlen(LineToSend), 0);
         readline(&LineToSend[0], sizeof(LineToSend), sockSocket);

         if (LineToSend[0]!=answPos)
         {
            printf(ErrorOccured, &(LineToSend[4]));
            exit(0);
         }
         else printf("%s\n", LineToSend);

   // *** PASS
         sprintf(LineToSend, "pass %s\r\n", argv[2]);
         rc=send(sockSocket, LineToSend, strlen(LineToSend), 0);
         readline(&LineToSend[0], sizeof(LineToSend), sockSocket);

         if (LineToSend[0]!=answPos)
         {
            printf(ErrorOccured, &(LineToSend[4]));
            exit(0);
         }
         else printf("%s\n", LineToSend);

   // *** STAT
         sprintf(LineToSend, "stat\r\n");
         rc=send(sockSocket, LineToSend, strlen(LineToSend), 0);
         readline(&LineToSend[0], sizeof(LineToSend), sockSocket);

         if (LineToSend[0]!=answPos)
         {
            printf(ErrorOccured, &(LineToSend[4]));
            exit(0);
         }
         else printf("%s\n", LineToSend);

         sscanf(&LineToSend[4], "%d %d", &nums, &bts);
         printf("Total messages %d, %d bytes\n", nums, bts);

   /*
   // *** LIST
         sprintf(LineToSend, "list\r\n");
         rc=send(sockSocket, LineToSend, strlen(LineToSend), 0);
         do
         {
            readline(&(LineToSend[0]), sizeof(LineToSend), sockSocket);
            printf("%s\n", LineToSend);
         } while (LineToSend[0]!='.');
   */

   // *** TOP
         for (i=1;i<=nums;i++)
         {
            sprintf(LineToSend, "top %d 0\r\n", i);
            rc=send(sockSocket, LineToSend, strlen(LineToSend), 0);
            do
            {
               readline(&(LineToSend[0]), sizeof(LineToSend), sockSocket);

               ii=(int*)LineToSend;
               word=*ii;
               word|=0x20202020;

               if (word==wrdSubj || word==wrdFrom)
// *** decode goes here...
                  printf("%s\n", sbjDecode(strDecoded, (char*)&LineToSend)); // before
            }
            while (LineToSend[0]!='.');
         }
      }
   }
}

