// NOTE this file best edit in editor with 100 columns

#include "perfplug.h"

// Globals

HMODULE	hmod;
HAB	hab;

void CopyFontSettings(HPS hpsSrc, HPS hpsDst)
{
   FONTMETRICS fm;
   FATTRS fat;
   SIZEF sizf;

   GpiQueryFontMetrics(hpsSrc, sizeof(FONTMETRICS), &fm);

   memset(&fat, 0, sizeof(fat));

   fat.usRecordLength = sizeof(FATTRS);
   fat.lMatch = fm.lMatch;
   strcpy(fat.szFacename, fm.szFacename);

   GpiDeleteSetId(hpsDst, 1L);
   GpiCreateLogFont(hpsDst, 0, 1L, &fat);
   GpiSetCharSet(hpsDst, 1L);

   sizf.cx = MAKEFIXED(fm.lEmInc,0);
   sizf.cy = MAKEFIXED(fm.lMaxBaselineExt,0);
   GpiSetCharBox(hpsDst, &sizf);
}

BOOL DestroyGraphicsBuffer(HPS hpsBuffer, HDC hdcBuffer)
{
   HBITMAP hbm;

   if(hpsBuffer && hdcBuffer)
   {
      hbm = GpiSetBitmap(hpsBuffer, NULLHANDLE);

      if (hbm != NULLHANDLE) GpiDeleteBitmap(hbm);

      GpiDestroyPS(hpsBuffer);
      DevCloseDC(hdcBuffer);
   }

return TRUE;
}

BOOL BlitGraphicsBuffer(HPS hps, HPS hpsBuffer, PRECTL prclPaint)
{
    POINTL aptl[3];

    aptl[0].x = prclPaint->xLeft;
    aptl[0].y = prclPaint->yBottom;
    aptl[1].x = prclPaint->xRight;
    aptl[1].y = prclPaint->yTop;
    aptl[2].x = prclPaint->xLeft;
    aptl[2].y = prclPaint->yBottom;

    GpiBitBlt(hps, hpsBuffer, 3L, aptl, ROP_SRCCOPY, BBO_IGNORE);

return TRUE;
}

BOOL CreateGraphicsBuffer(PRECTL prectl, HPS src, HPS *phpsBuffer, HDC *phdcBuffer)
{
   LONG cPlanes;
   LONG cBitCount;
   ULONG ulFlags;
   HBITMAP hbm;
   BITMAPINFOHEADER bmp;
   SIZEL sizl;
   FONTMETRICS fm;
   FATTRS fat;
   SIZEF sizf;
   RECTL rclPaint;
   HPS hps, hpsBuffer;
   HDC hdc, hdcBuffer;

   rclPaint = *prectl;
   hps = src;

   hdc = GpiQueryDevice(hps);
   ulFlags = GpiQueryPS(hps, &sizl);

   hdcBuffer = DevOpenDC(0, OD_MEMORY, "*", 0L, NULL, hdc);
   if (hdcBuffer)
   {
      sizl.cx = sizl.cy = 0;

      hpsBuffer = GpiCreatePS(0, hdcBuffer, &sizl, ulFlags | GPIA_ASSOC);

      *phpsBuffer = hpsBuffer;
      *phdcBuffer = hdcBuffer;

      DevQueryCaps(hdc, CAPS_COLOR_PLANES, 1L, &cPlanes);
      DevQueryCaps(hdc, CAPS_COLOR_BITCOUNT, 1L, &cBitCount);

      bmp.cbFix = sizeof(BITMAPINFOHEADER);
      bmp.cx = (SHORT)(rclPaint.xRight - rclPaint.xLeft);
      bmp.cy = (SHORT)(rclPaint.yTop - rclPaint.yBottom);
      bmp.cPlanes = (SHORT)cPlanes;
      bmp.cBitCount = (SHORT)cBitCount;

      hbm = GpiCreateBitmap(hpsBuffer,
                            (PBITMAPINFOHEADER2)&bmp,
                            0x0000,
                            (PBYTE)NULL,
                            (PBITMAPINFO2)NULL);
      if (hbm)
      {
         GpiSetBitmap(hpsBuffer, hbm);
         GpiQueryFontMetrics(hps, sizeof(FONTMETRICS), &fm);

         memset(&fat, 0, sizeof(fat));

         fat.usRecordLength = sizeof(FATTRS);
         fat.lMatch = fm.lMatch;
         strcpy(fat.szFacename, fm.szFacename);

         GpiDeleteSetId(hpsBuffer, 1L);
         GpiCreateLogFont(hpsBuffer, 0, 1L, &fat);
         GpiSetCharSet(hpsBuffer, 1L);

         sizf.cx = MAKEFIXED(fm.lEmInc, 0);
         sizf.cy = MAKEFIXED(fm.lMaxBaselineExt,0);
         GpiSetCharBox(hpsBuffer, &sizf);

         GpiCreateLogColorTable(hpsBuffer, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL); // finally !
         return TRUE;
      }

      GpiDestroyPS(hpsBuffer);
      DevCloseDC(hdcBuffer);
   }

return FALSE;
}

void  CleanString(char *t)
{
   char *p;

   if (!strlen (t)) return;

   p = t + strlen(t) - 1;

   while (*p == ' ')
   {
      if(p == t) break; *p = '\0';
      p --;
   }

   p = t;

   while(*p)
   {
      if ((*p == 13) || (*p == 10)) *p = ' ';
      p ++;
   }
}

VOID QueryTextBox(HPS hps, PSZ pszText, PSIZEL pszl)
{
   POINTL txtPointl[TXTBOX_COUNT];

   GpiQueryTextBox(hps, strlen(pszText), pszText, TXTBOX_COUNT, (PPOINTL)&txtPointl[0]);

   pszl->cx = txtPointl[TXTBOX_TOPRIGHT].x - txtPointl[TXTBOX_TOPLEFT].x;

   pszl->cy = txtPointl[TXTBOX_TOPLEFT].y - txtPointl[TXTBOX_BOTTOMLEFT].y;

}

LONG GetItemTextColor(HWND hwnd)
{
   ULONG ul,
         ulfg;

   WinQueryPresParam(hwnd, PP_FOREGROUNDCOLOR, NULL, &ul, sizeof(LONG), &ulfg, QPF_PURERGBCOLOR);

return (LONG)ulfg;
}

LONG GetItemBackColor(HWND hwnd)
{
   ULONG ul,
         ulbg;

   WinQueryPresParam(hwnd, PP_BACKGROUNDCOLOR, NULL, &ul, sizeof(LONG), &ulbg, QPF_PURERGBCOLOR);

return (LONG)ulbg;
}

LONG GetItemFont(HWND hwnd, PSZ pszFont)
{
   ULONG ul, ulbg;

   WinQueryPresParam(hwnd, PP_FONTNAMESIZE, NULL, &ul, 56, pszFont, 0);

return (LONG)strlen(pszFont);
}

VOID SetItemTextColor(HWND hwnd, LONG lColor)
{
   WinSetPresParam(hwnd, PP_FOREGROUNDCOLOR, sizeof(LONG), &lColor);
}

VOID SetItemBackColor(HWND hwnd, LONG lColor)
{
   WinSetPresParam(hwnd, PP_BACKGROUNDCOLOR, sizeof(LONG), &lColor);
}

VOID SetItemFont(HWND hwnd, PSZ pszFont)
{
   WinSetPresParam(hwnd, PP_FONTNAMESIZE, 56, pszFont);
}

void DrawFence(HPS hps, PRECTL prcl, ULONG ulRadius)
{
   POINTL ptl;

   GpiSetLineType(hps, LINETYPE_DOT);
   GpiSetColor(hps, 0x00000000);

   ptl.x = prcl->xLeft; ptl.y = prcl->yBottom;

   GpiMove(hps ,&ptl);

   ptl.x = prcl->xRight-1; ptl.y = prcl->yTop-1;

   GpiBox(hps, DRO_OUTLINE, &ptl, (LONG)ulRadius, (LONG)ulRadius);
   GpiSetLineType(hps, LINETYPE_SOLID);
}

HWND DublicateMenu(HWND hwndSourceMenu, HWND hwndParentMenu)
{
   CHAR buf[CBMAXSTRING];
   INT iItemCount, i;

   HWND hwndNewMenu = WinCreateMenu(hwndParentMenu, NULL);
   MENUITEM miCopy = {MIT_END, MIS_SEPARATOR, 0, 0, 0, 0};

   if(!hwndNewMenu) return NULLHANDLE;

   iItemCount = (INT)WinSendMsg(hwndSourceMenu, MM_QUERYITEMCOUNT, 0, 0);

   if (iItemCount <= 0)
   {
      WinDestroyWindow(hwndNewMenu);
      return NULLHANDLE;
   }

   for(i = 0; i < iItemCount; i++)
   {
      MENUITEM mi;
      INT iID = (INT)WinSendMsg(hwndSourceMenu, MM_ITEMIDFROMPOSITION, (MPARAM)i, 0);

      WinSendMsg(hwndSourceMenu, MM_QUERYITEM, MPFROM2SHORT(iID, TRUE), MPFROMP(&mi));
      WinSendMsg(hwndSourceMenu, MM_QUERYITEMTEXT, MPFROM2SHORT(iID, CBMAXSTRING), MPFROMP(buf));

      mi.iPosition = i; // Hei, thats Great!

      if(mi.hwndSubMenu) mi.hwndSubMenu = DublicateMenu(mi.hwndSubMenu, hwndNewMenu);

      WinSendMsg(hwndNewMenu, MM_INSERTITEM, MPFROMP(&mi), MPFROMP(buf));
   }

return hwndNewMenu;
}

BOOL EXPENTRY RegisterPlugin(HMODULE hm, HAB habSystray, PWCLASS pwc, PUSHORT n)
{
   if(*n < 1) return FALSE;

   hmod = hm;
   hab = habSystray;

   *n = 1;
   CpuMonRegister(hab, hm, pwc);
   pwc++;

return TRUE;
}

BOOL EXPENTRY DeRegisterPlugin(HMODULE hm, HAB habSystray)
{
   CpuMonDeregister(hab, hm);

return TRUE;
}
