/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************/

#include "systray.h"
#include "lang\str_ids.h"

BOOL APIENTRY WinStretchPointer(HPS hps, LONG lx, LONG ly, LONG lcx, LONG lcy,
                                HPOINTER hPointer, ULONG ulHalftone);

/*
 * This file contain all Systray View window stuff...
 */

extern CHAR szSystrayViewClass[];
extern HMODULE hmSystrayRes;
extern INT iViews;
extern PVIEWDATA SystrayView[MAXVIEWS];
extern HMODULE hmSystray;
extern PWCLASS pWClasses;
extern ULONG   ulClasses;
extern CHAR szSystrayHintClass[];
extern CHAR szSystrayLogoClass[];
extern CHAR szHelpPath[];

/*
 * private data
 */

extern HPOINTER hptrGrpUp, hptrGrpDown, hptrTrack, hptrTrays;

PSZ	pszHintText = NULL;
HWND    hwndAnchorHint = NULLHANDLE, hwndHint = NULLHANDLE;
BOOL    fMenuBelow, fMenuWork = FALSE;
POINTL  ptlBelow;


HWND ViewNewView(PVIEWDATA pViewData)
{
ULONG ulFrame = FCF_NOBYTEALIGN | FCF_ICON;
PFNWP OrgFrameProc;

pViewData->hwnd_Frame = WinCreateStdWindow(HWND_DESKTOP, 0, &ulFrame, szSystrayViewClass,
                                           _wpQueryTitle(pViewData->somSelf),
                                           0, hmSystray, IDR_STICON, &pViewData->hwnd);

DosPostEventSem(pViewData->hev); // unlock caller thread

if(!pViewData->hwnd_Frame) return NULLHANDLE;

SystrayView[iViews] = pViewData;
iViews++;

DbgPrintf("New view - %s (hwnd=%d)\n", _wpQueryTitle(pViewData->somSelf), pViewData->hwnd);

pViewData->UseItem.type    = USAGE_OPENVIEW;
pViewData->ViewItem.view   = STDEF_VIEWSYSTRAY;
pViewData->ViewItem.handle = pViewData->hwnd_Frame;

// add to WPS-in-use object list

_wpAddToObjUseList(pViewData->somSelf, &pViewData->UseItem);

// add to registered WPS tasklist

_wpRegisterView(pViewData->somSelf, pViewData->hwnd_Frame, "Systray");

// add "real" object icon to frame window

WinSendMsg(pViewData->hwnd_Frame, WM_SETICON, (MPARAM)_wpQueryIcon(pViewData->somSelf), 0L);

WinSetWindowULong(pViewData->hwnd, 0L, (ULONG)pViewData);

OrgFrameProc = WinSubclassWindow(pViewData->hwnd_Frame, (PFNWP)ViewSubclFrameProc);
WinSetWindowULong(pViewData->hwnd_Frame, QWL_USER, (ULONG)OrgFrameProc);

pViewData->hwnd_Popup = NULLHANDLE;
pViewData->fHidden = FALSE;
pViewData->fGrpClicked = FALSE;

if(pViewData->usUnits) UctCreateSavedUnits(pViewData);
else if(pViewData->viewConfig.fFirstRun && (iViews == 1)) // 0.3.6 default config
  {
  ViewMakeDefaultUnits(pViewData);
  _wpDisplayHelp(pViewData->somSelf, 100, szHelpPath);
  pViewData->viewConfig.fFirstRun = FALSE;
  }

SetItemBackColor(pViewData->hwnd, pViewData->viewConfig.ulBackColor);
pViewData->fUpdateDesktop = TRUE;
ViewUpdateView(pViewData);

return pViewData->hwnd_Frame;
}

void ViewMakeDefaultUnits(PVIEWDATA pViewData)
{
int i;
PSZ pszDefaultClasses[] =
  {"SPLG_SysTray",
   "SPLG_CpuMon",
   "SPLG_Toolbar",
   "SPLG_TaskBar",
   "SPLG_WarpButton",
   NULL};

DbgPrintf("Systray is empty - create default configuration\n");

i = 0;

while(pszDefaultClasses[i])
  {
  if(GenSearchClass(pszDefaultClasses[i]))
    {
    if(UctAddUnit(pViewData, pszDefaultClasses[i], 0))
      DbgPrintf("%s added successfully\n", pszDefaultClasses[i]);
    }
  i++;
  }
}

void ViewUpdateView(PVIEWDATA pViewData)
{
RECTL rcl;
USHORT usHeight = pViewData->viewConfig.page2.bBorderWidth*2 +
                  pViewData->viewConfig.page2.bViewSpacing
                  * (1 + pViewData->viewConfig.bRows) + // small visual hack ;)
                  pViewData->viewConfig.page2.bRowHeight *
                  pViewData->viewConfig.bRows;

// ----- First stage - initialize Systray Size
WinSetWindowPos(pViewData->hwnd_Frame, NULLHANDLE, 0, 0,
                WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN),
                usHeight, SWP_SIZE);

// ----- Second stage - setup view position & show it

if(pViewData->viewConfig.page1.fBottom)
   WinSetWindowPos(pViewData->hwnd_Frame, HWND_TOP, 0, 0, 0, 0,
                   SWP_MOVE | SWP_ZORDER | SWP_SHOW);
else
   WinSetWindowPos(pViewData->hwnd_Frame, HWND_TOP, 0, WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) -
                   usHeight, 0, 0, SWP_MOVE | SWP_ZORDER | SWP_SHOW);

// ----- Now, resize desktop

if(pViewData->fUpdateDesktop)
  GenUpdateDesktopArea();

pViewData->fUpdateDesktop = FALSE;

if(pViewData->usUnits) UctUpdateUnitsView(pViewData);

// update self view
WinQueryWindowRect(pViewData->hwnd, &rcl);
WinInvalidateRect(pViewData->hwnd, &rcl, TRUE);

//CnfConfigSave(pViewData->szIniFile, pViewData->szIniApp, pViewData); // ... and save updated settings
}

void DrawFence(HPS hps, PRECTL prcl, ULONG ulRadius)
{
POINTL ptl;

GpiSetLineType(hps, LINETYPE_DOT);

GpiSetColor(hps, 0x00000000);

ptl.x = prcl->xLeft; ptl.y = prcl->yBottom;

GpiMove(hps ,&ptl);

ptl.x = prcl->xRight-1; ptl.y = prcl->yTop-1;

GpiBox(hps, DRO_OUTLINE, &ptl, (LONG)ulRadius, (LONG)ulRadius);

GpiSetLineType(hps, LINETYPE_SOLID);
}

void ViewPaint(PVIEWDATA pvd, BOOL fFenced, BOOL fDragged)
{
HPS hps;
RECTL rcl;
SWP swp;
BOOL fPrevGrp = FALSE;
HPOINTER hptr;
BYTE bSizeWidth;
ULONG ulBackColor = (ULONG)-1, ul, i,
      cxBorder = WinQuerySysValue(HWND_DESKTOP, SV_CXBORDER),
      cxSizeBorder = 2;

bSizeWidth = (!pvd->viewConfig.page2.fHideSpacebars) ?
             (cxBorder + cxSizeBorder)             : 0;


if(!fDragged)
  {
  ulBackColor = GetItemBackColor(pvd->hwnd);

  if(ulBackColor < 0x01000000UL)
    pvd->viewConfig.ulBackColor = ulBackColor;
  else
    ulBackColor = pvd->viewConfig.ulBackColor; // hold "real" color if strange error
  }
  else ulBackColor = pvd->viewConfig.ulBackColor;

WinQueryWindowRect(pvd->hwnd, &rcl);

hps = fDragged ? DrgGetPS(pvd->hwnd) : WinBeginPaint(pvd->hwnd, 0L, 0L);

GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL); // switch to raw rgb mode

WinFillRect(hps, &rcl, ulBackColor);

ul = (ULONG)pvd->viewConfig.page2.bBorderWidth;
if(ul) WinDrawBorder(hps, &rcl, ul, ul, 0L, 0L, 0x400L);

if(fFenced) DrawFence(hps, &rcl, ul*4);

hptr = hptrTrays; //pvd->viewConfig.fBottom ? hptrGrpUp : hptrGrpDown; // choose better image

for(i=0; i<pvd->usUnits; i++)
  {
  if(!fPrevGrp) // skip hidden grouped units
    {

    WinQueryWindowPos(pvd->pUnits[i]->hwnd,&swp);

    if(pvd->pUnits[i]->fGrpNext) // draw unit group list icon (space already reserved in UctUpdate)
      {
      INT y = (pvd->viewConfig.page2.bRowHeight - WinQuerySysValue(HWND_DESKTOP, SV_CYICON)/2)/2;
      WinDrawPointer(hps, swp.x - pvd->viewConfig.page2.bRowHeight + y, swp.y + y,
                     hptr, DP_MINI);
      }

    if(((pvd->pUnits[i]->fGrpNext) || (pvd->pUnits[i]->usFlags & STUF_MANUAL))
       // NEW 0.1.8
       && (!pvd->viewConfig.page2.fHideSpacebars)) // draw resize hand
      {
      rcl.xLeft = cxBorder + swp.x + swp.cx +
                  (pvd->viewConfig.page2.fDrawVertbars ? 2 : 0);
      rcl.xRight = rcl.xLeft + cxSizeBorder;
      rcl.yBottom = swp.y;
      rcl.yTop = swp.y + swp.cy;
      WinDrawBorder(hps, &rcl, cxBorder, cxBorder, 0L, 0L, 0x400L);
      }

    if(pvd->viewConfig.page2.fDrawVertbars)
      {
      POINTL ptl;
      ptl.x = swp.x + swp.cx + 1;
      ptl.y = swp.y - pvd->viewConfig.page2.bViewSpacing;
      //rcl.yTop = swp.y + swp.cy + pvd->viewConfig.page2.bViewSpacing;
      GpiMove(hps, &ptl);
      ptl.y = swp.y + swp.cy + pvd->viewConfig.page2.bViewSpacing - 1;
      GpiSetColor(hps, WinQuerySysColor(HWND_DESKTOP, SYSCLR_BUTTONDARK, 0L));
      GpiLine(hps, &ptl);
      ptl.x = swp.x + swp.cx + 2;
      ptl.y = swp.y - pvd->viewConfig.page2.bViewSpacing;
      GpiMove(hps, &ptl);
      ptl.y = swp.y + swp.cy + pvd->viewConfig.page2.bViewSpacing - 1;
      GpiSetColor(hps, WinQuerySysColor(HWND_DESKTOP, SYSCLR_BUTTONLIGHT, 0L));
      GpiLine(hps, &ptl);
      }

    if(((pvd->viewConfig.page2.fFramedUnits && (pvd->pUnits[i]->usFlags & STUF_STATIC))
       || (pvd->viewConfig.page2.fFramedAll && (!(pvd->pUnits[i]->usFlags & STUF_STATIC)))
       || (pvd->pUnits[i]->usFlags & STUF_FRAMED))
       && pvd->viewConfig.page2.bViewSpacing) // draw some frame around
      {                                // old systray alike ;-)
      rcl.xLeft = swp.x - 1;
      rcl.xRight = swp.x + swp.cx + 1;
      rcl.yBottom = swp.y - 1;
      rcl.yTop = swp.y + swp.cy + 1;
      WinDrawBorder(hps, &rcl, 1, 1, 0L, 0L, 0x800L); // sunken frame...

      }
    }
  fPrevGrp = pvd->pUnits[i]->fGrpNext;
  }

if(fDragged) DrgReleasePS(hps);
else         WinEndPaint(hps);

}

BOOL TrackUnitSize(PVIEWDATA pvd, INT iIndex)
{
SWP swp;
RECTL rcl;
INT iWidth;
TRACKINFO tiStruct;

tiStruct.cxBorder = 2;
tiStruct.cyBorder = 2;
tiStruct.cxGrid = 0;
tiStruct.cyGrid = 0;
WinQueryWindowPos(pvd->pUnits[iIndex]->hwnd, &swp);

tiStruct.rclTrack.xLeft = swp.x; tiStruct.rclTrack.xRight = swp.x + swp.cx;
tiStruct.rclTrack.yBottom = swp.y; tiStruct.rclTrack.yTop = swp.y + swp.cy;

iWidth = pvd->pUnits[iIndex]->iWidth;
rcl.xLeft = pvd->viewConfig.page2.bBorderWidth + pvd->viewConfig.page2.bViewSpacing;
rcl.yBottom = rcl.xLeft + (pvd->viewConfig.bRows - pvd->pUnits[iIndex]->iRow - 1)
              * (pvd->viewConfig.page2.bRowHeight +
                 pvd->viewConfig.page2.bViewSpacing);
rcl.xRight = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) - rcl.xLeft -
             WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER) -
             WinQuerySysValue(HWND_DESKTOP, SV_CXBORDER);
rcl.yTop = rcl.yBottom + pvd->viewConfig.page2.bRowHeight;

memcpy(&tiStruct.rclBoundary, &rcl, sizeof(rcl));

tiStruct.ptlMinTrackSize.x = 4;
tiStruct.ptlMinTrackSize.y = rcl.yTop - rcl.yBottom;
tiStruct.ptlMaxTrackSize.y = rcl.yTop - rcl.yBottom;
tiStruct.ptlMaxTrackSize.x = abs(rcl.xRight - rcl.xLeft);
tiStruct.fs = TF_STANDARD | TF_ALLINBOUNDARY | TF_RIGHT | TF_BOTTOM;

WinTrackRect(pvd->hwnd, (HPS)0L, &tiStruct);

if(iWidth != abs(tiStruct.rclTrack.xRight - tiStruct.rclTrack.xLeft))
  {
  pvd->pUnits[iIndex]->iWidth = abs(tiStruct.rclTrack.xRight - tiStruct.rclTrack.xLeft);
  return TRUE;
  }

return FALSE;
}

// {{{ 0.3.6

BOOL TrackBarPosition(PVIEWDATA pvd)
{
SWP swp;
RECTL rcl;
TRACKINFO tiStruct;
BOOL fNewPos;

WinShowWindow(hwndHint, FALSE);
WinQueryWindowPos(pvd->hwnd_Frame, &swp);
tiStruct.cxBorder = 2;
tiStruct.cyBorder = 2;
tiStruct.cxGrid = 1;
tiStruct.cyGrid = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - swp.cy;

tiStruct.rclTrack.xLeft = swp.x;
tiStruct.rclTrack.xRight = swp.x + swp.cx;
tiStruct.rclTrack.yBottom = swp.y;
tiStruct.rclTrack.yTop = swp.y + swp.cy;

rcl.xLeft = 0;
rcl.yBottom = 0;
rcl.xRight = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN);
rcl.yTop = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) + 1;

memcpy(&tiStruct.rclBoundary, &rcl, sizeof(rcl));

tiStruct.ptlMinTrackSize.x = swp.cx;
tiStruct.ptlMinTrackSize.y = swp.cy;
tiStruct.ptlMaxTrackSize.y = swp.cy;
tiStruct.ptlMaxTrackSize.x = swp.cx;
tiStruct.fs = TF_MOVE | TF_GRID | TF_ALLINBOUNDARY;

WinTrackRect(WinQueryWindow(pvd->hwnd_Frame, QW_PARENT), (HPS)0L, &tiStruct);

fNewPos = (tiStruct.rclTrack.yBottom == 0);

if(pvd->viewConfig.page1.fBottom != fNewPos)
  {
  pvd->viewConfig.page1.fBottom = fNewPos;
  pvd->fUpdateDesktop = pvd->viewConfig.page1.fResizeDesktop;
  ViewUpdateView(pvd);
  return TRUE;
  }

return FALSE;
}

BOOL TrackBarHeight(PVIEWDATA pvd)
{
SWP swp;
RECTL rcl;
TRACKINFO tiStruct;
int iRows;

WinShowWindow(hwndHint, FALSE);
WinQueryWindowPos(pvd->hwnd_Frame, &swp);
tiStruct.cxBorder = 2;
tiStruct.cyBorder = 2;
tiStruct.cxGrid = 1;
tiStruct.cyGrid = pvd->viewConfig.page2.bRowHeight + pvd->viewConfig.page2.bViewSpacing;

tiStruct.rclTrack.xLeft = swp.x;
tiStruct.rclTrack.xRight = swp.x + swp.cx;
tiStruct.rclTrack.yBottom = swp.y;
tiStruct.rclTrack.yTop = swp.y + swp.cy;

rcl.xLeft = 0;
rcl.yBottom = 0;
rcl.xRight = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN);
rcl.yTop = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);

memcpy(&tiStruct.rclBoundary, &rcl, sizeof(rcl));

tiStruct.ptlMinTrackSize.x = swp.cx;
tiStruct.ptlMinTrackSize.y = pvd->viewConfig.page2.bRowHeight + pvd->viewConfig.page2.bViewSpacing;
tiStruct.ptlMaxTrackSize.y = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);
tiStruct.ptlMaxTrackSize.x = swp.cx;
tiStruct.fs = TF_GRID | TF_ALLINBOUNDARY | (pvd->viewConfig.page1.fBottom ? TF_TOP : TF_BOTTOM);

WinTrackRect(WinQueryWindow(pvd->hwnd_Frame, QW_PARENT), (HPS)0L, &tiStruct);

iRows = (tiStruct.rclTrack.yTop - tiStruct.rclTrack.yBottom) /
        (pvd->viewConfig.page2.bRowHeight + pvd->viewConfig.page2.bViewSpacing);

if(iRows != pvd->viewConfig.bRows)
  {
  pvd->viewConfig.bRows = iRows;
  pvd->fUpdateDesktop = pvd->viewConfig.page1.fResizeDesktop;
  ViewUpdateView(pvd);  
  return TRUE;
  }

return FALSE;
}


int ViewCheckPointer(PVIEWDATA pvd, PPOINTL pptl)
{
HPS hps;
RECTL rcl;
SWP swp;
INT i;
BOOL fPrevGrp = FALSE;
ULONG cxBorder = WinQuerySysValue(HWND_DESKTOP, SV_CXBORDER),
      cxSizeBorder = WinQuerySysValue(HWND_DESKTOP, SV_CXSIZEBORDER),
      cyArea = pvd->viewConfig.page2.bBorderWidth + pvd->viewConfig.page2.bViewSpacing;

WinQueryWindowRect(pvd->hwnd, &rcl);

if(((pptl->y <= cyArea) && !pvd->viewConfig.page1.fBottom) ||
   ((pptl->y >= rcl.yTop - cyArea) && pvd->viewConfig.page1.fBottom))
  {
  return 0x8000; // resize pointer
  }

for(i=0; i<pvd->usUnits; i++)
  {
  if(!fPrevGrp) // skip hidden grouped units
    {

    WinQueryWindowPos(pvd->pUnits[i]->hwnd,&swp);

    if((pptl->x >= swp.x) && (pptl->x<(swp.x+swp.cx)) &&
       (pptl->y >= swp.y) && (pptl->y<(swp.y+swp.cy))) return i;

    if(pvd->pUnits[i]->fGrpNext) // draw unit group list icon (space already reserved in UctUpdate)
    if((pptl->x >= swp.x - pvd->viewConfig.page2.bRowHeight - 1) &&
       (pptl->x< (swp.x + swp.cx - pvd->viewConfig.page2.bRowHeight - 1)) &&
       (pptl->y >= swp.y) && (pptl->y<(swp.y + swp.cy)))
      return (i | 0x1000); // grouplist

    if((pvd->pUnits[i]->fGrpNext) || (pvd->pUnits[i]->usFlags & STUF_MANUAL)) // draw resize hand
      {
      rcl.xLeft = cxBorder + swp.x + swp.cx;
      rcl.xRight = rcl.xLeft + cxSizeBorder;
      rcl.yBottom = swp.y;
      rcl.yTop = swp.y + swp.cy;

      if((pptl->x >= rcl.xLeft) && (pptl->x <= rcl.xRight) &&
         (pptl->y >= rcl.yBottom) && (pptl->y <= rcl.yTop))
        return (i | 0x2000); // resizing
      }
    }
  fPrevGrp = pvd->pUnits[i]->fGrpNext;
  }
return -1;
}

BOOL    ViewCommand(PVIEWDATA pvd, MPARAM mp1, MPARAM mp2)
{
BOOL rc = TRUE;

if(pvd->fGrpClicked)
  {
  INT iLastIndex = (INT)((USHORT)mp1) - STIDC_GROUPID;
  if((iLastIndex >= 0) && (iLastIndex > pvd->iGrpClicked))
    {
    if(UctSwapGroup(pvd, pvd->iGrpClicked, iLastIndex))
      ViewUpdateView(pvd);
    }
  }
else
  switch((USHORT)mp1)
    {
    case STIDC_PRODINFO:
    WinDlgBox(HWND_DESKTOP, pvd->hwnd, LogoWindowProc, hmSystrayRes, 2000, NULL);
    break;

    case STIDC_CLOSE: // selected Close from Systray view popup menu
    WinPostMsg(pvd->hwnd_Frame, WM_SYSCOMMAND, (MPARAM)SC_CLOSE, (MPARAM)0L);
    break;

    default: // "dynamic" messages

    // took menu command into WPS handler (subclassed Frame window)
    if((USHORT)mp1 < WPMENUID_USER)
      WinSendMsg(pvd->hwnd_Frame, WM_COMMAND, mp1, mp2);

    // add unit selected
    if(((USHORT)mp1 > STIDC_ADDUNIT) && ((USHORT)mp1 < (STIDC_ADDUNIT + ulClasses + 1L)))
      {
      INT iAdd;
      POINTL ptl;
      RECTL rcl;
      WinQueryPointerPos(HWND_DESKTOP, &ptl);
      WinMapWindowPoints(HWND_DESKTOP, pvd->hwnd, &ptl, 1);
      iAdd = UctUnitFromPoint(pvd, &ptl, &rcl);
      if(iAdd < 0) iAdd = 0;
      if(UctAddUnit(pvd, pWClasses[(SHORT)mp1 - STIDC_ADDUNIT - 1].pszName, iAdd))
        ViewUpdateView(pvd);
      else DosBeep(1000, 100);
      }

    // group selected unit
    if(((USHORT)mp1 > STIDC_GROUPID) && ((USHORT)mp1 < STIDC_USER))
      {
      DosBeep(1000, 100); // none now!
      }

    break;
    }

return rc;
}

VOID    EnableMenuClassList(HWND hwndMenu, PVIEWDATA pvd)
{
ULONG i, j, n;
MENUITEM mi;
HWND hwndClassMenu;

if(!WinSendMsg(hwndMenu, MM_QUERYITEM,
    MPFROM2SHORT(STIDC_ADDUNIT, TRUE), MPFROMP(&mi))) return;

hwndClassMenu = mi.hwndSubMenu;

for(i=0; i<ulClasses; i++)
  {
  n = 0;
  for(j=0; j<pvd->usUnits; j++)
    if(!strcmp(pWClasses[i].pszName, pvd->pUnits[j]->szClass))
      n ++;

  WinSendMsg(hwndClassMenu, MM_QUERYITEM,
             MPFROM2SHORT(STIDC_ADDUNIT + i + 1, FALSE), MPFROMP(&mi));

  if((n>=pWClasses[i].usMaxUnits) && pWClasses[i].usMaxUnits)
    mi.afAttribute |= MIA_DISABLED;
  else
    mi.afAttribute &= ~MIA_DISABLED;

  WinSendMsg(hwndClassMenu, MM_SETITEM, // enable or disable menu item
             MPFROM2SHORT(STIDC_ADDUNIT + i + 1, FALSE), MPFROMP(&mi));
  }
}

VOID    BuildMenuClassList(HWND hwndMenu)
{
MENUITEM mi;
HWND hwndSubMenu;
INT i;

if(ulClasses)
  {
  hwndSubMenu = WinCreateMenu(HWND_DESKTOP, NULL); // create empty menu

  if(hwndSubMenu)
    {
    mi.iPosition = MIT_END; mi.afAttribute = mi.id = mi.hItem = 0;
    mi.hwndSubMenu = NULLHANDLE; mi.afStyle = MIS_SEPARATOR;

    WinSendMsg(hwndMenu, MM_INSERTITEM, MPFROMP(&mi), (MPARAM)NULL);

    mi.iPosition = MIT_END; mi.afAttribute = 0;
    mi.id = STIDC_ADDUNIT;
    mi.hItem = 0;
    mi.hwndSubMenu = hwndSubMenu; mi.afStyle = MIS_TEXT | MIS_SUBMENU;

    WinSendMsg(hwndMenu, MM_INSERTITEM, MPFROMP(&mi),
               MPFROMP(GenLoadNls(NULL, IDS_ADDUNIT, "Add unit")));

    for(i = 0; i<ulClasses; i++)
      {
      mi.iPosition = MIT_END; mi.afAttribute = 0;
      mi.id = STIDC_ADDUNIT + i + 1;
      mi.hItem = 0;
      mi.hwndSubMenu = NULLHANDLE;
      mi.afStyle = MIS_TEXT;
      WinSendMsg(hwndSubMenu, MM_INSERTITEM, MPFROMP(&mi),
                 MPFROMP(pWClasses[i].pszViewName));
      }
    }
  }
}

MRESULT EXPENTRY SubclMenuProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PFNWP     orgMenuProc;

orgMenuProc = (PFNWP)WinQueryWindowULong(hwnd, QWL_USER);

switch(msg)
  {
  case WM_ADJUSTWINDOWPOS:
    {
    PSWP pswp = (PSWP)mp1;
    if(pswp)
      {
      if(/*pswp->x && pswp->y &&*/ pswp->cx && pswp->cy) // bUgOfIx ;#)
        {
        ULONG   cxScreen = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN),
                cyScreen = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);

        if(fMenuBelow)
          {
          pswp->y = ptlBelow.y - pswp->cy;
          pswp->x = ptlBelow.x;
          fMenuBelow = FALSE;
          }

        if(pswp->x + pswp->cx > cxScreen)
          pswp->x = cxScreen - pswp->cx;
        if(pswp->y + pswp->cy > cyScreen)
          pswp->y = cyScreen - pswp->cy;
        }
      }
    break;
    }
  }

return orgMenuProc(hwnd, msg, mp1, mp2);
}

BOOL    ViewGroupMenu(PVIEWDATA pvd, MPARAM mp1, INT iIndex)
{
POINTL ptl;
RECTL rcl;
HPS hps;
MENUITEM mi;
PWCLASS pwc;
INT iLastIndex, i;
static HWND hwndGroupMenu = NULLHANDLE;

iLastIndex = UctGetLastInGroup(pvd, iIndex);

if(iLastIndex == iIndex) return FALSE;

if(hwndGroupMenu) WinDestroyWindow(hwndGroupMenu);

hwndGroupMenu = WinCreateMenu(HWND_DESKTOP, NULLHANDLE); // make empty menu

if(!hwndGroupMenu) return FALSE;

ptl.x = 0; //SHORT1FROMMP(mp1); // get mouse pointer position
ptl.y = 0; //SHORT2FROMMP(mp1);

WinQueryWindowRect(pvd->pUnits[iIndex]->hwnd, &rcl);
ptl.y = pvd->viewConfig.page1.fBottom ? rcl.yTop : 0;
WinMapWindowPoints(pvd->pUnits[iIndex]->hwnd, HWND_DESKTOP, &ptl, 1);
ptl.x -= rcl.yTop;

for(i = iIndex; i <= iLastIndex; i++)
  {
  pwc = GenSearchClass(pvd->pUnits[i]->szClass);
  if(pwc)
    {
    static CHAR buf[CBMAXSTRING];
    if(WinSendMsg(pvd->pUnits[i]->hwnd, USTM_FILLGROUPTITLE,
                  MPFROMP(buf), MPFROMLONG(sizeof(buf))))
      {
      strcat(buf, " - ");
      strcat(buf, pvd->pUnits[i]->szUnitTitle[0] ?
                  pvd->pUnits[i]->szUnitTitle : pwc->pszViewName);
      } else
      strcpy(buf, pvd->pUnits[i]->szUnitTitle[0] ?
                  pvd->pUnits[i]->szUnitTitle : pwc->pszViewName);

    mi.iPosition = MIT_END;
    mi.afAttribute = (i == iIndex) ? MIA_CHECKED : 0;
    mi.id = STIDC_GROUPID + i;
    mi.hItem = 0;
    mi.hwndSubMenu = NULLHANDLE;
    mi.afStyle = MIS_TEXT;
    WinSendMsg(hwndGroupMenu, MM_INSERTITEM,
               MPFROMP(&mi), MPFROMP(buf));
    }
  }

pvd->fGrpClicked = TRUE;
pvd->iGrpClicked = iIndex;

if(!pvd->viewConfig.page1.fBottom)
  {
  PFNWP orgMenuProc = WinSubclassWindow(hwndGroupMenu, (PFNWP)SubclMenuProc);
  WinSetWindowULong(hwndGroupMenu, QWL_USER, (ULONG)orgMenuProc);
  fMenuBelow = TRUE;
  ptlBelow = ptl;
  }

return WinPopupMenu(pvd->hwnd, pvd->hwnd, hwndGroupMenu,
                    ptl.x, ptl.y, 0, PU_HCONSTRAIN   | PU_VCONSTRAIN |
                                     PU_MOUSEBUTTON1 | PU_KEYBOARD   );
}

VOID    ViewControlPopup(PVIEWDATA pvd)
{
CHAR szClass[CBMAXSTRING];
BOOL fFrameVisible = WinIsWindowVisible(pvd->hwnd_Frame);
HWND hwndTop = WinQueryWindow(HWND_DESKTOP, QW_TOP);

if(fMenuWork) return;

if(pvd->viewConfig.page1.bOntopMethod == ONTOP_ALWAYS)
  {
  if((hwndTop == pvd->hwnd_Frame) || // what else? client??? oh, yes...
     (hwndTop == pvd->hwnd)) return;

  WinQueryClassName(hwndTop, CBMAXSTRING, szClass); // check for menu...

  if((szClass[0] == '#') && (szClass[1] == '4')) return;

  WinSetWindowPos(pvd->hwnd_Frame, HWND_TOP, 0L, 0L, 0L, 0L, SWP_ZORDER);

  //if(!strcmp(szClass, szSystrayHintClass)) // 0.2.6
    WinSetWindowPos(hwndHint, HWND_TOP, 0L, 0L, 0L, 0L, SWP_ZORDER);
  }

if(pvd->viewConfig.page1.bOntopMethod == ONTOP_POPUP)
  {
  POINTL ptl;
  RECTL rcl;
  if((hwndTop == pvd->hwnd_Frame) || // what else? client??? oh, yes...
     (hwndTop == pvd->hwnd)) return;

  WinQueryClassName(hwndTop, CBMAXSTRING, szClass); // check for menu...

  if((szClass[0] == '#') && (szClass[1] == '4')) return;

  WinQueryPointerPos(HWND_DESKTOP, &ptl);
  //WinMapWindowPoints(HWND_DESKTOP, pvd->hwnd, &ptl, 1); // hmmm 0.3.2
  //WinQueryWindowRect(pvd->hwnd, &rcl);
  if((!pvd->viewConfig.page1.fBottom && (ptl.y > WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - 2))
  || (pvd->viewConfig.page1.fBottom && (ptl.y < 2)))
    {
    WinSetWindowPos(pvd->hwnd_Frame, HWND_TOP, 0L, 0L, 0L, 0L, SWP_ZORDER);

    //if(!strcmp(szClass, szSystrayHintClass)) // 0.2.6
      WinSetWindowPos(hwndHint, HWND_TOP, 0L, 0L, 0L, 0L, SWP_ZORDER);
    }
  }

if(pvd->viewConfig.page1.bOntopMethod == ONTOP_POPHIDE)
  {
  POINTL ptl;
  RECTL rcl;

  WinQueryClassName(hwndTop, CBMAXSTRING, szClass); // check for menu...

  if((szClass[0] == '#') && (szClass[1] == '4')) return;

  WinQueryPointerPos(HWND_DESKTOP, &ptl);
  //WinMapWindowPoints(HWND_DESKTOP, pvd->hwnd, &ptl, 1); // 0.3.2
  WinQueryWindowRect(pvd->hwnd, &rcl);

  if((!pvd->viewConfig.page1.fBottom && (ptl.y > WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - 2))
  || (pvd->viewConfig.page1.fBottom && (ptl.y < 2)))
    {
//    WinStopTimer(WinQueryAnchorBlock(pvd->hwnd), pvd->hwnd, TMR_HIDEDELAY);
    WinSetWindowPos(pvd->hwnd_Frame, HWND_TOP, 0L, 0L, 0L, 0L, SWP_ZORDER | SWP_SHOW);
    pvd->iHideTemp = (INT)pvd->viewConfig.page1.bHideDelay*10;
    //if(!strcmp(szClass, szSystrayHintClass)) // 0.2.6 workaround
      WinSetWindowPos(hwndHint, HWND_TOP, 0L, 0L, 0L, 0L, SWP_ZORDER);
    } else if(WinIsWindowVisible(pvd->hwnd_Frame) && // very tricky code ;-)
              WinMapWindowPoints(HWND_DESKTOP, pvd->hwnd, &ptl, 1) && // 0.3.2
              !WinPtInRect(WinQueryAnchorBlock(pvd->hwnd), &rcl, &ptl))
    {
//    WinShowWindow(pvd->hwnd_Frame, FALSE);
//    WinShowWindow(hwndHint, FALSE); // 0.3.2
// 0.3.6
//    WinStartTimer(WinQueryAnchorBlock(pvd->hwnd), pvd->hwnd,
//                  TMR_HIDEDELAY, (ULONG)pvd->viewConfig.page1.bHideDelay*1000);
    if(pvd->iHideTemp == 0)
      {
      WinShowWindow(pvd->hwnd_Frame, FALSE);
      WinShowWindow(hwndHint, FALSE);
      pvd->iHideTemp = (INT)pvd->viewConfig.page1.bHideDelay*10;
      }
    else pvd->iHideTemp --;
    }
  }
}

BOOL    ViewContextMenu(PVIEWDATA pvd, MPARAM mp1, MPARAM mp2)
{
POINTL ptl;
RECTL rcl;
HPS hps;
MENUITEM mi;

ptl.x = SHORT1FROMMP(mp1); // get mouse pointer position
ptl.y = SHORT2FROMMP(mp1);

pvd->iRow = pvd->viewConfig.bRows - ptl.y / (pvd->viewConfig.page2.bBorderWidth
                                           + pvd->viewConfig.page2.bViewSpacing
                                           + pvd->viewConfig.page2.bRowHeight) - 1;

if(pvd->iRow < 0) pvd->iRow = 0;

if(pvd->iRow >= pvd->viewConfig.bRows)
  pvd->iRow = pvd->viewConfig.bRows - 1;

// Grab object menu from WPS

if(pvd->hwnd_Popup) WinDestroyWindow(pvd->hwnd_Popup);
//pvd->hwnd_Popup = WinCreateMenu(pvd->hwnd, NULL);
//_wpModifyPopupMenu(pvd->somSelf, pvd->hwnd_Popup, NULLHANDLE, -1);

pvd->hwnd_Popup = _wpDisplayMenu(pvd->somSelf, pvd->hwnd_Frame,
                                 pvd->hwnd, &ptl,
                                 MENU_NODISPLAY | MENU_OBJECTPOPUP,
                                 0);

if(pvd->hwnd_Popup == NULLHANDLE) // warp3 fixaround
  {
  HWND hwndSub2;

  pvd->hwnd_Popup = WinCreateMenu(HWND_DESKTOP, NULLHANDLE); // make empty menu
  mi.iPosition = MIT_END;
  mi.afAttribute = 0;
  mi.hItem = 0;
  hwndSub2 = mi.hwndSubMenu = WinCreateMenu(pvd->hwnd_Popup, NULL);
  mi.iPosition = MIT_END;
  mi.afStyle = MIS_TEXT | MIS_SUBMENU;
  mi.id = -1;

  WinSendMsg(pvd->hwnd_Popup, MM_INSERTITEM, MPFROMP(&mi),
             MPFROMP(GenLoadNls(NULL, IDS_SYSTRAY,"Systray")));

  mi.iPosition = MIT_END;
  mi.afAttribute = 0;
  mi.hItem = 0;
  mi.hwndSubMenu = NULLHANDLE;
  mi.afStyle = 0;
  mi.iPosition = MIT_END;
  mi.afStyle = MIS_TEXT;
  mi.id = WPMENUID_PROPERTIES;

  WinSendMsg(hwndSub2, MM_INSERTITEM, MPFROMP(&mi),
             MPFROMP(GenLoadNls(NULL, IDS_PROPERTIES, "Settings")));

  mi.id = STIDC_PRODINFO;

  WinSendMsg(hwndSub2, MM_INSERTITEM, MPFROMP(&mi),
             MPFROMP(GenLoadNls(NULL, IDS_PRODINFO, "~Product information")));

  _wpModifyPopupMenu(pvd->somSelf, pvd->hwnd_Popup, NULLHANDLE, 0);
  }

// Add classlist to popup menu

BuildMenuClassList(pvd->hwnd_Popup);
EnableMenuClassList(pvd->hwnd_Popup, pvd);

// Add separator to popup menu

mi.iPosition = MIT_END;
mi.afAttribute = 0;
mi.id = 0;
mi.hItem = 0;
mi.hwndSubMenu = NULLHANDLE;
mi.afStyle = MIS_SEPARATOR;

WinSendMsg(pvd->hwnd_Popup, MM_INSERTITEM, MPFROMP(&mi), (MPARAM)NULL);

// Add "Close" to popup menu

mi.iPosition = MIT_END; mi.afStyle = MIS_TEXT; mi.id = STIDC_CLOSE;

WinSendMsg(pvd->hwnd_Popup, MM_INSERTITEM, MPFROMP(&mi),
           MPFROMP(GenLoadNls(NULL, IDS_CLOSE, "~Close")));

// Product information
if(WinSendMsg(pvd->hwnd_Popup, MM_QUERYITEM, MPFROM2SHORT(2, TRUE), MPFROMP(&mi)))
  {
  // Add separator to popup menu
  HWND hwndSub = mi.hwndSubMenu;
  mi.iPosition = MIT_END;
  mi.afAttribute = 0;
  mi.id = 0;
  mi.hItem = 0;
  mi.hwndSubMenu = NULLHANDLE;
  mi.afStyle = MIS_SEPARATOR;

  WinSendMsg(hwndSub, MM_INSERTITEM, MPFROMP(&mi), (MPARAM)NULL);

  // Add "Product information" to popup menu

  mi.iPosition = MIT_END; mi.afStyle = MIS_TEXT; mi.id = STIDC_PRODINFO;

  WinSendMsg(hwndSub, MM_INSERTITEM, MPFROMP(&mi),
             MPFROMP(GenLoadNls(NULL, IDS_PRODINFO, "~Product information")));
  }

WinQueryWindowRect(pvd->hwnd, &rcl);

hps = WinGetPS(pvd->hwnd);
GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
DrawFence(hps, &rcl, pvd->viewConfig.page2.bBorderWidth*4);
WinReleasePS(hps);
WinEnableWindowUpdate(pvd->hwnd, FALSE);

pvd->fGrpClicked = FALSE;

if(!pvd->viewConfig.page1.fBottom)
  {
  PFNWP orgMenuProc = WinSubclassWindow(pvd->hwnd_Popup, (PFNWP)SubclMenuProc);
  WinSetWindowULong(pvd->hwnd_Popup, QWL_USER, (ULONG)orgMenuProc);
  fMenuBelow = TRUE;
  ptlBelow = ptl;
  WinMapWindowPoints(pvd->hwnd, HWND_DESKTOP, &ptlBelow, 1);
  }

return WinPopupMenu(pvd->hwnd, pvd->hwnd, pvd->hwnd_Popup,
                    ptl.x, ptl.y, 0, PU_HCONSTRAIN   | PU_VCONSTRAIN |
                                     PU_MOUSEBUTTON1 | PU_KEYBOARD   );
}

MRESULT EXPENTRY ViewSubclFrameProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PFNWP OrgFrameProc;

OrgFrameProc = (PFNWP)WinQueryWindowULong(hwnd, QWL_USER);

switch(msg)
  {
  case WM_SYSCOMMAND: // let Systray view to be removable from "Window List"

  switch ((USHORT)mp1)
    {
    case SC_CLOSE:
      WinDestroyWindow(hwnd);
      break;
    }
  return (MRESULT)0L;

  case WM_CLOSE: // other suxx...
  WinDestroyWindow(hwnd);
  return (MRESULT)0L;

  case WM_ADJUSTWINDOWPOS: // never activate
    {
    PSWP pswp = (PSWP)mp1;
    if(pswp->fl & SWP_ACTIVATE)
      {
      pswp->fl &= ~SWP_ACTIVATE;
      pswp->fl |= SWP_DEACTIVATE;
      if(hwndHint) WinShowWindow(hwndHint, FALSE);
      }
    return (MRESULT)0L;
    }

  case WM_FOCUSCHANGE:
  case WM_ADJUSTFRAMEPOS:
  case WM_ACTIVATE: // never activate
  return (MRESULT)0L;

  case WM_DESTROY:
    {
    INT i, j=0;

  //  DosBeep(1000, 100);
    for(i=0; i<iViews; i++)
      if(SystrayView[i]->hwnd_Frame != hwnd) // remove from our view list
        {
        SystrayView[j++] = SystrayView[i];
        }
    if(j < i) iViews--; // hack
    GenUpdateDesktopArea();
    break;
    }
  }

if(OrgFrameProc) return OrgFrameProc(hwnd, msg, mp1, mp2);

return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

MRESULT ViewDragOver(PVIEWDATA pvd, PDRAGINFO pdi)
{
USHORT    usDrop = DOR_NEVERDROP, usDefOp = 0;
PDRAGINFO pDragInfo = pdi;
PDRAGITEM pDragItem;

if(DrgAccessDraginfo(pDragInfo))
  {

  // The only items we will let be dropped on us are WPS objects
  // which use the <DRM_DDE,DRF_UNKNOWN> RMF.

  if(pDragItem && (pDragInfo->hwndSource == pvd->hwnd)/* &&
     DrgVerifyRMF(pDragItem, "DRM_DDE", "DRF_UNKNOWN")*/)
    {
    usDrop  = DOR_DROP;
    usDefOp = DO_MOVE;
    }

  DrgFreeDraginfo(pDragInfo);
  }

return MRFROM2SHORT(usDrop, usDefOp);
}

void ViewDragDrop(PVIEWDATA pvd, PDRAGINFO pdi)
{
PDRAGINFO pDragInfo = pdi;

if(DrgAccessDraginfo(pDragInfo))
  {
  PDRAGITEM pDragItem;
  PUNIT pUnit;
  POINTL ptl;
  RECTL rcl;
  INT i, iAlong;

  //WinQueryPointerPos(HWND_DESKTOP, &ptl);
  ptl.x = pDragInfo->xDrop;
  ptl.y = pDragInfo->yDrop;
  WinMapWindowPoints(HWND_DESKTOP, pvd->hwnd, &ptl, 1);
  iAlong = UctUnitFromPoint(pvd, &ptl, &rcl);

  pDragItem = DrgQueryDragitemPtr(pDragInfo, 0);

  if(pDragItem && pDragItem->ulItemID)
    {
    pUnit = (PUNIT)pDragItem->ulItemID;

    for(i = 0; i < pvd->usUnits; i++)
      {
      if((iAlong != -1) && (pvd->pUnits[i] == pUnit))
        {
        PPICKEDUNITS ppu = UctPickupUnits(pvd, i);
        if(ppu) UctDropUnits(pvd, iAlong, ppu);
        break;
        }
      }
    }
  }
DrgDeleteDraginfoStrHandles(pDragInfo);
DrgFreeDraginfo(pDragInfo);
}

MRESULT EXPENTRY ViewWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
HPS hps;
RECTL rcl;
PVIEWDATA pvd;
POINTL ptl;
static BOOL fDrgInvert = FALSE;

pvd = (PVIEWDATA)WinQueryWindowULong(hwnd, 0L);

switch(msg)
  {
  case u_WM_MOVEALONGWINDOW:
  if(pvd->usUnits == 0) // small tip if Systray started first time
    {
    ViewDisplayHint(hwnd, GenLoadNls(NULL, IDS_MAINHINT,
                          "Click right mouse button for context menu"));
    }
  break;

  case WM_MOUSEMOVE:
    {
    INT i;
    POINTL ptl;
    ptl.x = SHORT1FROMMP(mp1); // get mouse pointer position
    ptl.y = SHORT2FROMMP(mp1);

    i = ViewCheckPointer(pvd, &ptl);
    if(i == 0x8000) // bar height track
      WinSetPointer(HWND_DESKTOP, WinQuerySysPointer(HWND_DESKTOP, SPTR_SIZENS, FALSE));
    else
    if(i >= 0x2000)
      WinSetPointer(HWND_DESKTOP, hptrTrack);
    else WinSetPointer(HWND_DESKTOP, WinQuerySysPointer(HWND_DESKTOP, SPTR_ARROW, FALSE));
    return (MRESULT)0L;
    }

  case WM_BUTTON1DOWN:
    {
    INT i;
    POINTL ptl;
    ptl.x = SHORT1FROMMP(mp1); // get mouse pointer position
    ptl.y = SHORT2FROMMP(mp1);
    i = ViewCheckPointer(pvd, &ptl);
    if(i == 0x8000) // bar height track
      TrackBarHeight(pvd);
    else
    if((i >= 0x1000) && (i<0x2000))
      {
      fMenuWork = ViewGroupMenu(pvd, mp1, i & 0x0FFF);
      }
      else
      if(i >= 0x2000)
        {
        if(TrackUnitSize(pvd, i & 0x0FFF))
          ViewUpdateView(pvd);
        }// else TrackBarPosition(pvd);
    return (MRESULT)0L;
    }

  case VTM_IMPORTVC:
//  memcpy((PVIEWCONFIG)mp1, &pvd->viewConfig, sizeof(VIEWCONFIG));
  if(((ULONG)mp2) & 1) // page1
    memcpy(&((PVIEWCONFIG)mp1)->page1, &pvd->viewConfig.page1,
           sizeof(pvd->viewConfig.page1));

  if(((ULONG)mp2) & 2) // page2
    memcpy(&((PVIEWCONFIG)mp1)->page2, &pvd->viewConfig.page2,
           sizeof(pvd->viewConfig.page2));

  if(((ULONG)mp2) & 0x8000) // page1
    memcpy((PVIEWCONFIG)mp1, &pvd->viewConfig, sizeof(VIEWCONFIG));

  return (MRESULT) TRUE;

  case VTM_EXPORTVC:
  pvd->fUpdateDesktop = TRUE;
//  memcpy(&pvd->viewConfig, (PVIEWCONFIG)mp1, sizeof(VIEWCONFIG));
  if(((ULONG)mp2) & 1) // page1
    memcpy(&pvd->viewConfig.page1, &((PVIEWCONFIG)mp1)->page1,
           sizeof(pvd->viewConfig.page1));

  if(((ULONG)mp2) & 2) // page2
    memcpy(&pvd->viewConfig.page2, &((PVIEWCONFIG)mp1)->page2, 
           sizeof(pvd->viewConfig.page2));

  if(((ULONG)mp2) & 0x8000) // page1
    memcpy(&pvd->viewConfig, (PVIEWCONFIG)mp1, sizeof(VIEWCONFIG));

  ViewUpdateView(pvd);
  break;

  case VTM_POPUP:
  ViewUpdateView(pvd);
  return (MRESULT)0L;

  case VTM_SAVECONFIG:
  CnfConfigSave(pvd->szIniFile,pvd->szIniApp, pvd);
  break;

  case WM_CREATE:
  // main timer start
  WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, TMR_MAINTIMER, 1000);
  // hi-res timer
  WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, TMR_HIRESTIMER, 100);
  break;

  case WM_TIMER:
  switch((SHORT)mp1) // timer select
    {
//    case TMR_HIDEDELAY: // 0.3.6
//    WinShowWindow(pvd->hwnd_Frame, FALSE);
//    WinShowWindow(hwndHint, FALSE);

//    WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, TMR_HIDEDELAY);
//    break;

    case TMR_MAINTIMER: // general update timer
    UctTimerUpdate(pvd); // update timered units
    break;

    case TMR_HIRESTIMER:
    ViewControlPopup(pvd);
    break;
    }
  break;

  case WM_ERASEBACKGROUND:
  return (MRESULT)0L;

  case DM_DRAGOVER:
    {
    HPS hpsDrg;
    INT iAlong;
    WinQueryPointerPos(HWND_DESKTOP, &ptl);
    WinMapWindowPoints(HWND_DESKTOP, pvd->hwnd, &ptl, 1);
    iAlong = UctUnitFromPoint(pvd, &ptl, &rcl);

    ViewPaint(pvd, FALSE, TRUE);

    if(iAlong != -1)
      {
      hpsDrg = DrgGetPS(hwnd);
      WinDrawBorder(hpsDrg, &rcl, 2L, 2L, CLR_WHITE, CLR_WHITE, DB_DESTINVERT);
      DrgReleasePS(hpsDrg);
      }
    return (iAlong == -1) ? 0 : ViewDragOver(pvd, (PDRAGINFO)mp1);
    }

  case DM_DRAGLEAVE:
  ViewPaint(pvd, FALSE, TRUE);
  break;

  case DM_DROP:
    {
    ViewPaint(pvd, FALSE, TRUE);
    ViewDragDrop(pvd, (PDRAGINFO)mp1);
    WinPostMsg(hwnd, VTM_POPUP, (MPARAM)0L, (MPARAM)0L);
    break;
    }

  case WM_PAINT:
  ViewPaint(pvd, FALSE, FALSE);
  return (MRESULT)0L;

  case WM_CONTEXTMENU:
  fMenuWork = ViewContextMenu(pvd, mp1, mp2);
  break;

  case WM_BEGINDRAG:
  return (MRESULT)TrackBarPosition(pvd);

  case WM_BUTTON1DBLCLK:
  if((SHORT2FROMMP(mp2) & KC_SHIFT) && (SHORT2FROMMP(mp2) & KC_CTRL))
    {
    WinDlgBox(HWND_DESKTOP, hwnd, LogoWindowProc, hmSystrayRes, 2000, NULL);
    }
  break;

  case WM_CHORD: // specially for [dagor] ;-)
  CnfConfigSave(pvd->szIniFile, pvd->szIniApp, pvd);
  DosBeep(500, 5);    DosBeep(600, 5);    DosBeep(800, 5);
  break;

  case WM_MENUEND:
  if(pvd->hwnd_Popup && ((HWND)mp2 == pvd->hwnd_Popup))
    {
    WinEnableWindowUpdate(hwnd, TRUE);
    WinQueryWindowRect(hwnd, &rcl);
    WinInvalidateRect(hwnd, &rcl, TRUE);
    }
  fMenuWork = FALSE;
  break;

  case WM_PRESPARAMCHANGED:
  WinQueryWindowRect(hwnd, &rcl);
  WinInvalidateRect(hwnd, &rcl, TRUE);
  break;

  case WM_COMMAND:
  ViewCommand(pvd, mp1, mp2);
  return (MRESULT)0L;

  case WM_SYSCOMMAND:
  return (MRESULT)0L;

  case WM_SAVEAPPLICATION:
  CnfConfigSave(pvd->szIniFile, pvd->szIniApp, pvd);
  break;

  case WM_DESTROY:

  // Now, we wanna to remove opened Systray view from WPS-in-use object list

  _wpDeleteFromObjUseList(pvd->somSelf, &pvd->UseItem);

  // Save configuration

  CnfConfigSave(pvd->szIniFile, pvd->szIniApp, pvd);

  // Release Unit Memory

  UctReleaseAll(pvd);

  // Finally, release View memory

  free(pvd);
  if(hwndHint) WinShowWindow(hwndHint, FALSE); // hint uncollision
  return (MRESULT)0L;

  case WM_CLOSE:
  WinDestroyWindow(WinQueryWindow(hwnd, QW_PARENT));
  return (MRESULT)0L;
  }

return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

// hints followed...

VOID    QueryTextBox(HPS hps, PSZ pszText, PSIZEL pszl)
{
POINTL txtPointl[TXTBOX_COUNT];
PSZ psz = strchr(pszText, '\n');
int len = strlen(pszText);

if(psz && ((ULONG)psz - (ULONG)pszText < len))
  len = (int)((ULONG)psz - (ULONG)pszText);

GpiQueryTextBox(hps, len, pszText, TXTBOX_COUNT,
                (PPOINTL)&txtPointl[0]);

pszl->cx = txtPointl[TXTBOX_TOPRIGHT].x - txtPointl[TXTBOX_TOPLEFT].x;

pszl->cy = txtPointl[TXTBOX_TOPLEFT].y - txtPointl[TXTBOX_BOTTOMLEFT].y;

}

BOOL    ViewDisplayHint(HWND hwnd, PSZ pszText)
{
POINTL ptl;
SIZEL szl;
HPS hps;
CHAR szWindowClass[CBMAXSTRING];
PVIEWDATA pvd;
PSZ psz;
HWND hwndPar = hwnd, hwndTop = WinQueryWindow(HWND_DESKTOP, QW_TOP);

WinQueryClassName(hwndPar, CBMAXSTRING, szWindowClass);

while(strcmp(szWindowClass, szSystrayViewClass))
  {
  hwndPar = WinQueryWindow(hwndPar, QW_PARENT);
  if(hwndPar)
    WinQueryClassName(hwndPar, CBMAXSTRING, szWindowClass);
  else return FALSE; // unknown parent?
  }

pvd = (PVIEWDATA)WinQueryWindowULong(hwndPar, 0L);

if(pvd->viewConfig.page2.fDisableHint) return FALSE;

WinQueryClassName(hwndTop, CBMAXSTRING, szWindowClass);
if(!strcmp(szWindowClass, "#4")) return FALSE;

if(!hwndHint)
  hwndHint = WinCreateWindow(HWND_DESKTOP, szSystrayHintClass, "", 0L, 0L, 0L, 0L, 0L,
                             NULLHANDLE, HWND_TOP, 0xFACE, (PVOID)NULL, (PVOID)NULL);

if(!pszText)
  {
  WinShowWindow(hwndHint, FALSE);
  return FALSE;
  }

if(pszHintText && (hwnd == hwndAnchorHint) && (!strcmp(pszText, pszHintText))) return FALSE;

WinQueryPointerPos(HWND_DESKTOP, &ptl);

if(pszHintText) free(pszHintText);
pszHintText = strdup(pszText);
hwndAnchorHint = hwnd;

SetItemFont(hwndHint, "9.WarpSans");
hps = WinGetPS(hwndHint);
psz = pszText; szl.cx = 0; szl.cy = 0;

// may be multiple-lined hint?
while(psz)
  {
  SIZEL szl2;

  QueryTextBox(hps, psz, &szl2);

  if(szl2.cx > szl.cx) szl.cx = szl2.cx; szl.cy += szl2.cy;
  psz = strchr(psz, '\n'); if(psz) psz++; // next line
  }

WinReleasePS(hps);

if(ptl.y < WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN)/2)
  ptl.y += 8;
else
  ptl.y -= szl.cy + WinQuerySysValue(HWND_DESKTOP, SV_CYICON)/2;

if((ptl.x + szl.cx + 4) > WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN))
  ptl.x = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) - szl.cx - 4;

if((ptl.y + szl.cy + 4) > WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN))
  ptl.y = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - szl.cy - 4;

WinSetWindowPos(hwndHint, HWND_TOP, ptl.x, ptl.y,
                szl.cx + 4, szl.cy + 4,
                SWP_MOVE | SWP_SIZE | SWP_ZORDER | SWP_HIDE);

WinStartTimer(WinQueryAnchorBlock(hwndHint), hwndHint, TMR_HINTSHOW,
              pvd->viewConfig.page2.fFastHints ? 100 : 700);

return TRUE;
}

MRESULT EXPENTRY HintWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
HPS hps;
RECTL rcl;
POINTL ptl;
SIZEL szl;
PSZ psz;

switch(msg)
  {
  case WM_WINDOWPOSCHANGED:
  //DosBeep(2000, 40);
  break;

  case WM_SHOW:
  if(SHORT1FROMMP(mp1))
    WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, TMR_HINTHIDE, 3000); // wait 3 seconds
  break;

  case WM_TIMER:
  switch((USHORT)mp1)
    {
    case TMR_HINTHIDE:
    WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, TMR_HINTHIDE);
    WinShowWindow(hwnd, FALSE);
    break;
    case TMR_HINTSHOW:
      {
      HWND hwndTop = WinQueryWindow(HWND_DESKTOP, QW_TOP);
      CHAR szWindowClass[CBMAXSTRING];
      POINTL ptl;
      WinQueryClassName(hwndTop, CBMAXSTRING, szWindowClass);
      WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, TMR_HINTSHOW);

      if(!strcmp(szWindowClass, "#4"))
        break;

      WinQueryPointerPos(HWND_DESKTOP, &ptl);

      if(WinWindowFromPoint(HWND_DESKTOP, &ptl, TRUE) == hwndAnchorHint)
        {
        hps = WinGetPS(hwnd);
        psz = pszHintText; szl.cx = 0; szl.cy = 0;

        // may be multiple-lined hint?
        while(psz)
          {
          SIZEL szl2;

          QueryTextBox(hps, psz, &szl2);

          if(szl2.cx > szl.cx) szl.cx = szl2.cx; szl.cy += szl2.cy;
          psz = strchr(psz, '\n');  if(psz) psz++; // next line
          }

        WinReleasePS(hps);

        if(ptl.y < WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN)/2)
          ptl.y += 8;
        else
          ptl.y -= szl.cy + WinQuerySysValue(HWND_DESKTOP, SV_CYICON)/2;

        if((ptl.x + szl.cx + 4) > WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN))
          ptl.x = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) - szl.cx - 4;
 
        if((ptl.y + szl.cy + 4) > WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN))
          ptl.y = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN) - szl.cy - 4;

        WinSetWindowPos(hwndHint, HWND_TOP, ptl.x, ptl.y, 0, 0, 
                        SWP_MOVE | SWP_ZORDER | SWP_SHOW);
        }
      }
    break;
    }
  break;

  case WM_ERASEBACKGROUND:
  return (MRESULT)TRUE;

  case WM_PAINT:
  WinQueryWindowRect(hwnd, &rcl);
  hps = WinBeginPaint(hwnd, 0, 0);
  GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL);
  GpiSetColor(hps, 0x000FFFFD8);
  ptl.x = rcl.xLeft; ptl.y = rcl.yBottom;
  GpiMove(hps ,&ptl);
  ptl.x = rcl.xRight-1; ptl.y = rcl.yTop-2; // hmm...
  GpiBox(hps, DRO_FILL, &ptl, 0, 0
         /*(LONG)(rcl.yTop-rcl.yBottom)/2, (LONG)(rcl.yTop-rcl.yBottom)/2*/);

  GpiSetColor(hps, 0x00888864);
  ptl.x = rcl.xLeft; ptl.y = rcl.yBottom;
  GpiMove(hps ,&ptl);
  ptl.x = rcl.xRight-1; ptl.y = rcl.yTop-1; // bug here???
  GpiBox(hps, DRO_OUTLINE, &ptl, 0, 0
         /*(LONG)(rcl.yTop-rcl.yBottom)/2, (LONG)(rcl.yTop-rcl.yBottom)/2*/);

  psz = pszHintText;
  rcl.yTop -= 2;
  rcl.xLeft += 2; rcl.xRight -=2;
  //WinDrawText(hps, -1, psz, &rcl, 0x00000000, 0L, DT_CENTER | DT_VCENTER | DT_WORDBREAK);
  while(psz)
    {
    QueryTextBox(hps, psz, &szl);
    rcl.yBottom = rcl.yTop - szl.cy;
    WinDrawText(hps, -1, psz, &rcl, 0x00000000, 0L, DT_WORDBREAK);
    rcl.yTop = rcl.yBottom;
    psz = strchr(psz, '\n'); if(psz) psz++;
    }
  WinEndPaint(hps);
  return (MRESULT)TRUE;

  case WM_DESTROY:
  hwndHint = NULLHANDLE;
  break;

  case WM_HITTEST:
  return (MRESULT)HT_TRANSPARENT;
  }

return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY RectSubclProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
HPS hps;
RECTL rcl;
POINTL ptl;
BITMAPINFOHEADER bmpData;
HBITMAP hbmLogo = (HBITMAP)WinQueryWindowULong(WinQueryWindow(hwnd, QW_PARENT), QWL_USER);
PFNWP OrgRectProc = (PFNWP)WinQueryWindowULong(hwnd, QWL_USER);


switch(msg)
  {
  case WM_PAINT:

  bmpData.cbFix = sizeof(BITMAPINFOHEADER);
  GpiQueryBitmapParameters(hbmLogo, &bmpData);

  WinQueryWindowRect(hwnd, &rcl);
  hps = WinBeginPaint(hwnd, 0, 0);

  GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG)NULL);

  WinDrawBorder(hps, &rcl, 1, 1, 0L, 0L, 0x800L);

  rcl.xLeft ++; rcl.yBottom ++;
  rcl.xRight --; rcl.yTop --;

  //GpiErase(hps);
  WinFillRect(hps, &rcl, (183*0x10000) + (212*0x100) + 235);

  ptl.x = (rcl.xRight - bmpData.cx) / 2;
  ptl.y = (rcl.yTop - bmpData.cy) / 2;

  if(hbmLogo)
    WinDrawBitmap(hps, hbmLogo, NULL, &ptl, 0L, 0L, DBM_NORMAL);

  WinEndPaint(hps);
  return (MRESULT)TRUE;
  }

return OrgRectProc(hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY LogoWindowProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
HPS hps;
PFNWP OrgRectProc;
static HBITMAP hbmLogo = NULLHANDLE;

switch(msg)
  {
  case WM_INITDLG:
  hps = WinGetPS(hwnd);
  hbmLogo = GpiLoadBitmap(hps, hmSystray, IDR_RTEAM2LOGO, 0L, 0L);
  WinSetWindowULong(hwnd, QWL_USER, (ULONG)hbmLogo);
  WinReleasePS(hps);

  OrgRectProc = WinSubclassWindow(WinWindowFromID(hwnd, 2001), (PFNWP)RectSubclProc);
  WinSetWindowULong(WinWindowFromID(hwnd, 2001), QWL_USER, (ULONG)OrgRectProc);

  WinSetDlgItemText(hwnd, 2004, ST_VERSION);
  break;

  case WM_DESTROY:
  if(hbmLogo)
    GpiDeleteBitmap(hbmLogo);
  break;
  }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}
