
/*
 * eas.h:
 *      header file for eas.c.
 *      This file is new with V0.81.
 *      See explanations in eas.c.
 *
 *      Function prefixes (new with V0.81):
 *      --  ea*         EA helper functions
 *
 *      Required #include's before including this header:
 *      --  OS2.H with INCL_DOS.
 */

/*
 *      Most of the code in this file dealing with Extended Attributes
 *      is based on code (w) by Chris Hanson (cph@zurich.ai.mit.edu).
 *      Copyright (c) 1995 Massachusetts Institute of Technology.
 *      The original code is available as EALIB.ZIP at Hobbes.
 *
 *      From that code is the following copyright notice:
 *
 *      This material was developed by the Scheme project at the Massachusetts
 *      Institute of Technology, Department of Electrical Engineering and
 *      Computer Science.  Permission to copy this software, to redistribute
 *      it, and to use it for any purpose is granted, subject to the following
 *      restrictions and understandings.
 *
 *      1. Any copy made of this software must include this copyright notice
 *      in full.
 *
 *      2. Users of this software agree to make their best efforts (a) to
 *      return to the MIT Scheme project any improvements or extensions that
 *      they make, so that these may be included in future releases; and (b)
 *      to inform MIT of noteworthy uses of this software.
 *
 *      3. All materials developed as a consequence of the use of this
 *      software shall duly acknowledge such use, in accordance with the usual
 *      standards of acknowledging credit in academic research.
 *
 *      4. MIT has made no warrantee or representation that the operation of
 *      this software will be error-free, and MIT is under no obligation to
 *      provide any services, by way of maintenance, update, or otherwise.
 *
 *      5. In conjunction with products arising from the use of this material,
 *      there shall be no use of the name of the Massachusetts Institute of
 *      Technology nor of any adaptation thereof in any advertising,
 *      promotional, or sales literature without prior written consent from
 *      MIT in each case.
 *
 *      This file Copyright (C) 1997-99 Ulrich Mller,
 *                                      Massachusetts Institute of Technology.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef EAS_HEADER_INCLUDED
    #define EAS_HEADER_INCLUDED

    typedef struct {
        BYTE bFlags;
        BYTE bNameLength;
        USHORT usValueLength;
        PSZ pszName;
        PSZ pszValue;
    } EABINDING, *PEABINDING;

    typedef struct _EALIST {
        EABINDING * binding;
        struct _EALIST * next;
    } EALIST, *PEALIST;


    /*
     * eaFreeBinding:
     *      deallocate EA binding memory that was generated
     *      by the ea...Read... procedures below. These procs
     *      assume that "malloc" was used for allocation and
     *      that the "name" and "value" fields of each binding
     *      were also allocated using "malloc". "value" may also
     *      be NULL.
     */

    void eaFreeBinding(PEABINDING binding);

    /*
     * eaFreeList:
     *      the same for an EA binding list.
     */

    void eaFreeList(PEALIST list);

    /*
     * All of the following functions come in two flavors:
     *
     *      eaHFile*    operate on an open file handle.
     *
     *      eaPath*     operate on any file specified by its
     *                  filename, which may be fully qualified.
     */

    /*
     * ------ READ EXTENDED ATTRIBUTES
     */

    /*
     * eaHFileQueryTotalSize / eaPathQueryTotalSize:
     *      returns the total size of all EAs.
     */

    ULONG eaHFileQueryTotalSize(HFILE hFile);

    ULONG eaPathQueryTotalSize(PSZ path);

    /*
     * eaHFileReadAll / eaPathReadAll:
     *      reads all of the extended attributes into an EALIST.
     *      Returns NULL if no EAs were found.
     *      The returned list should be freed using eaFreeList.
     */

    PEALIST eaHFileReadAll(HFILE hfile);

    PEALIST eaPathReadAll(PSZ path);

    /*
     * eaHFileReadOneByIndex / eaPathReadOneByIndex:
     *      returns one EA specified by a given index, counting
     *      from 1. Returns NULL if the specified index was not
     *      found, either because the file has no EAs at all or
     *      the index is too large.
     *      The returned binding should be freed using eaFreebinding.
     */

    PEABINDING eaHFileReadOneByIndex(HFILE hfile, ULONG index);

    PEABINDING eaPathReadOneByIndex(PSZ path, ULONG index);

    /*
     * eaHFileReadOneByName / eaPathReadOneByName:
     *      returns one EA specified by the given EA name (e.g.
     *      ".LONGNAME"). Returns NULL if not found.
     *      The returned binding should be freed using eaFreebinding.
     */

    PEABINDING eaHFileReadOneByName(HFILE hfile, PSZ name);

    PEABINDING eaPathReadOneByName(PSZ path, PSZ name);

    /*
     * ------ WRITE EXTENDED ATTRIBUTES
     */

    /*
     * eaHFileWriteAll / eaPathWriteAll:
     *      writes a list of EAs to a given file. These EAs
     *      are added to possibly existing EAs on the file.
     *      A given EA is deleted if its usValueLength field
     *      is 0; in that case, the value field may also be NULL.
     */

    void eaHFileWriteAll(HFILE hfile, PEALIST list);

    void eaPathWriteAll(PSZ path, PEALIST list);

    /*
     * eaHFileWriteOne / eaPathWriteOne:
     *      adds one EA to a given file.
     *      A given EA is deleted if its usValueLength field
     *      is 0; in that case, the value field may also be NULL.
     */

    void eaHFileWriteOne(HFILE hfile, PEABINDING binding);

    void eaPathWriteOne(PSZ path, PEABINDING binding);

#endif

#if __cplusplus
}
#endif

