
/*
 *@@sourcefile xfdataf.c:
 *      This file contains the following major XFolder parts:
 *
 *      --  XFldDataFile SOM stuff
 *
 *      Check the other files starting with xf* for the
 *      other XFolder classes.
 *
 *      XFldDataFile is responsible for menu manipulation
 *      and default icon replacements for data files.
 *      Since we should not override WPFileSystem to implement
 *      this functionality for folders and data files altogether,
 *      we must add this to WPDataFile separately.
 *
 *      Installation of this class is optional.
 *
 *@@somclass XFldDataFile xfdataf_
 *@@somclass M_XFldDataFile xfdatafM_
 */

/*
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

/*
 *  Suggested #include order:
 *  1)  os2.h
 *  2)  C library headers
 *  3)  SOM headers which work with precompiled header files
 *  4)  headers in /helpers
 *  5)  headers in /main with dlgids.h and common.h first
 *  6)  #pragma hdrstop to prevent VAC++ crashes
 *  7)  other needed SOM headers
 *  8)  for non-SOM-class files: corresponding header (e.g. classlst.h)
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using:
 *      SOM Emitter emitctm: 2.41
 */

#ifndef SOM_Module_xfdataf_Source
#define SOM_Module_xfdataf_Source
#endif
#define XFldDataFile_Class_Source
#define M_XFldDataFile_Class_Source

#define INCL_DOSSEMAPHORES      // needed for xthreads.h
#define INCL_DOSERRORS

#define INCL_WINSHELLDATA       // profile funcs
#define INCL_WINMENUS           // needed for menus.h
#define INCL_WINPOINTERS
#define INCL_WINSTDCNR          // needed for winh.h

#include <os2.h>

// C library headers

// headers in /helpers
#include "winh.h"               // PM helper routines

// SOM headers which don't crash with prec. header files
#include "xfdataf.ih"

// headers in /main
#include "dlgids.h"             // all the IDs that are shared with NLS
#include "common.h"             // the majestic XFolder include file

#include "menus.h"              // common XFolder context menu logic

// other SOM headers
#pragma hdrstop                 // VAC++ keeps crashing otherwise
#include <wpfolder.h>

/*
 * Global variables::
 *
 */

CHAR        szDataIconFile[CCHMAXPATH] = "";

/* ******************************************************************
 *                                                                  *
 *   here come the XFldDataFile instance methods                    *
 *                                                                  *
 ********************************************************************/

/*
 *@@ wpFilterPopupMenu:
 *           remove default entries according to Global Settings;
 *           even though XFldObject does this already, we need to
 *           override this for XFldDataFile again, because the
 *           WPS does it too for WPDataFile
 */

SOM_Scope ULONG  SOMLINK xfdataf_wpFilterPopupMenu(XFldDataFile *somSelf,
                                                   ULONG ulFlags,
                                                   HWND hwndCnr,
                                                   BOOL fMultiSelect)
{
    ULONG ulMenuFilter = 0;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();
    /* XFldDataFileData *somThis = XFldDataFileGetData(somSelf); */
    XFldDataFileMethodDebug("XFldDataFile","xfdataf_wpFilterPopupMenu");

    ulMenuFilter = XFldDataFile_parent_WPDataFile_wpFilterPopupMenu(somSelf,
                                                             ulFlags,
                                                             hwndCnr,
                                                             fMultiSelect);

    // now suppress default menu items according to
    // Global Settings;
    // the DefaultMenuItems field in pGlobalSettings is
    // ready-made for this function; the "Workplace Shell"
    // notebook page for removing menu items sets this field with
    // the proper CTXT_xxx flags
    return ((ulMenuFilter)
            & ~(pGlobalSettings->DefaultMenuItems)
        );
}

/*
 *@@ wpModifyPopupMenu:
 *           add datafile object popup menu entries. We don't
 *           need a wpMenuItemSelected method for data files,
 *           because the new menu items are completely handled
 *           by the subclassed folder frame window procedure
 *           by calling the functions in menus.c.
 */

SOM_Scope BOOL  SOMLINK xfdataf_wpModifyPopupMenu(XFldDataFile *somSelf,
                                                  HWND hwndMenu,
                                                  HWND hwndCnr,
                                                  ULONG iPosition)
{
    BOOL brc = TRUE;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();
    PNLSSTRINGS pNLSStrings = cmnQueryNLSStrings();

    /* XFldDataFileData *somThis = XFldDataFileGetData(somSelf); */
    XFldDataFileMethodDebug("XFldDataFile","xfdataf_wpModifyPopupMenu");

    brc = XFldDataFile_parent_WPDataFile_wpModifyPopupMenu(somSelf,
                                                             hwndMenu,
                                                             hwndCnr,
                                                             iPosition);

    // insert "Attributes" submenu (for data files
    // only, not for folders
    if (pGlobalSettings->FileAttribs)
    {
        ULONG ulAttr;
        HWND hwndAttrSubmenu;

        if (!pGlobalSettings->AddCopyFilenameItem)
            // separator not yet inserted: do it now
            winhInsertMenuSeparator(hwndMenu, MIT_END,
                        (pGlobalSettings->VarMenuOffset + ID_XFMI_OFS_SEPARATOR));

        // get this file's file-system attributes
        ulAttr = _wpQueryAttr(somSelf);
        // insert submenu
        hwndAttrSubmenu = winhInsertSubmenu(hwndMenu, MIT_END,
                    (pGlobalSettings->VarMenuOffset + ID_XFM_OFS_ATTRIBUTES),
                            pNLSStrings->pszAttributes, 0,
        // "archived" item, checked or not according to file-system attributes
                    (pGlobalSettings->VarMenuOffset + ID_XFMI_OFS_ATTR_ARCHIVED),
                            pNLSStrings->pszAttrArchived, MIS_TEXT,
                                ((ulAttr & FILE_ARCHIVED) ? MIA_CHECKED : 0));
        // "read-only" item, checked or not according to file-system attributes
        winhInsertMenuItem(hwndAttrSubmenu, MIT_END,
                    (pGlobalSettings->VarMenuOffset + ID_XFMI_OFS_ATTR_READONLY),
                            pNLSStrings->pszAttrReadOnly, MIS_TEXT,
                                ((ulAttr & FILE_READONLY) ? MIA_CHECKED : 0));
        // "system" item, checked or not according to file-system attributes
        winhInsertMenuItem(hwndAttrSubmenu, MIT_END,
                    (pGlobalSettings->VarMenuOffset + ID_XFMI_OFS_ATTR_SYSTEM),
                            pNLSStrings->pszAttrSystem, MIS_TEXT,
                                ((ulAttr & FILE_SYSTEM) ? MIA_CHECKED : 0));
        // "hidden" item, checked or not according to file-system attributes
        winhInsertMenuItem(hwndAttrSubmenu, MIT_END,
                    (pGlobalSettings->VarMenuOffset + ID_XFMI_OFS_ATTR_HIDDEN),
                            pNLSStrings->pszAttrHidden, MIS_TEXT,
                                ((ulAttr & FILE_HIDDEN) ? MIA_CHECKED : 0));
    }

    // insert "Copy filename" for data files
    // (the XFolder class does this also)
    if (pGlobalSettings->AddCopyFilenameItem)
    {
        /* winhInsertMenuSeparator(hwndMenu, MIT_END,
                    (pGlobalSettings->VarMenuOffset + ID_XFMI_OFS_SEPARATOR)); */

        winhInsertMenuItem(hwndMenu, MIT_END,
            (pGlobalSettings->VarMenuOffset + ID_XFMI_OFS_COPYFILENAME_MENU),
            (pNLSStrings)->pszCopyFilename,
            0, 0);
    }

    return (brc);
}

/*
 *@@ wpMenuItemHelpSelected:
 *           display help for a context menu item
 */

SOM_Scope BOOL  SOMLINK xfdataf_wpMenuItemHelpSelected(XFldDataFile *somSelf,
                                                       ULONG MenuId)
{
    /* XFldDataFileData *somThis = XFldDataFileGetData(somSelf); */
    XFldDataFileMethodDebug("XFldDataFile","xfdataf_wpMenuItemHelpSelected");

    // call the common help processor in menus.c;
    // if this returns TRUE, help was requested for one
    // of the new menu items
    if (mnuMenuItemHelpSelected(somSelf, MenuId))
        return TRUE;
    else
        // else: none of our menu items, call default
        return (XFldDataFile_parent_WPDataFile_wpMenuItemHelpSelected(somSelf,
                                                                 MenuId));
}

/* ******************************************************************
 *                                                                  *
 *   here come the XFldDataFile class methods                       *
 *                                                                  *
 ********************************************************************/

/*
 *@@ wpclsInitData:
 *           initialize class instance data
 */

SOM_Scope void  SOMLINK xfdatafM_wpclsInitData(M_XFldDataFile *somSelf)
{
    M_XFldDataFileData *somThis = M_XFldDataFileGetData(somSelf);
    M_XFldDataFileMethodDebug("M_XFldDataFile","xfdatafM_wpclsInitData");

    M_XFldDataFile_parent_M_WPDataFile_wpclsInitData(somSelf);
}

/*
 *@@ wpclsCreateDefaultTemplates:
 *           this is called by the system to allow a class to
 *           create its default templates. The default WPS
 *           behavior is to create new templates if the class
 *           default title is different from the existing
 *           templates, but since we are replacing the class,
 *           we will have to suppress this in order not to
 *           crowd the Templates folder.
 */

SOM_Scope BOOL  SOMLINK xfdatafM_wpclsCreateDefaultTemplates(M_XFldDataFile *somSelf,
                                                             WPObject* Folder)
{
    // M_XFldDataFileData *somThis = M_XFldDataFileGetData(somSelf);
    M_XFldDataFileMethodDebug("M_XFldDataFile","xfdatafM_wpclsCreateDefaultTemplates");

    // we only override this class method if it is
    // being called for the XFolder class object itself.
    // If this is being called for a subclass, we use
    // the parent method, because we do not want to
    // break the default behavior for subclasses.
    if (somSelf == _XFldDataFile)
        return (TRUE);
        // means that the Templates folder should _not_ create templates
        // by itself; we pretend that we've done this
    else
        return (M_XFldDataFile_parent_M_WPDataFile_wpclsCreateDefaultTemplates(somSelf,
                                                                           Folder));

}

/*
 *@@ wpclsQueryIconData:
 *           this class method gets called by our override of
 *           wpclsQueryIcon.
 *           Here we return the "data" icon file in the ICONS
 *           directory to specify replacement the class default
 *           icon.
 */

/*
 *@@ wpclsQueryIconData:
 *           give data files a new default icon, if the
 *           global settings allow this.
 *           This is loaded from /ICONS/ICONS.DLL.
 */

SOM_Scope ULONG  SOMLINK xfdatafM_wpclsQueryIconData(M_XFldDataFile *somSelf,
                                                     PICONINFO pIconInfo)
{
    ULONG ulrc;
    PGLOBALSETTINGS pGlobalSettings = cmnQueryGlobalSettings();
    // M_XFldDataFileData *somThis = M_XFldDataFileGetData(somSelf);
    M_XFldDataFileMethodDebug("M_XFldDataFile","xfdatafM_wpclsQueryIconData");

    if (pGlobalSettings->ReplIcons)
    {
        // icon replacements allowed:
        if (pIconInfo) {
            pIconInfo->fFormat = ICON_RESOURCE;
            pIconInfo->hmod = cmnQueryIconsDLL();
            pIconInfo->resid = 109;
        }
        ulrc = sizeof(ICONINFO);
    }
    else
        // icon replacements not allowed: call default
        ulrc = M_XFldDataFile_parent_M_WPDataFile_wpclsQueryIconData(somSelf,
                                                                  pIconInfo);

    return (ulrc);
}

