/* Make XFolder */
"@echo off"
/* make all XFolder files */

/*
    This will call nmake with all the makefiles in the
    subdirectories to update all parts of XFolder:
    the main module, the NLS DLLS, and  all the HLP and INF files.

    Note that there are some directory checks below which might
    not apply to your system, because I am also using this script
    to update my "private" XFolder parts which are not included
    in the source distribution.

    This script is smart enough though to check for the existence
    of those directories.
*/

/*
    Change the following if you need some cmd file
    which sets compiler variables; otherwise comment
    this out. This is only because I don't like all
    the VAC++ settings in CONFIG.SYS.
*/

"call envicc.cmd"

/*
    You MUST change the following to the path where
    you installed XFolder; the makefiles will automatically
    copy the resulting files thereto.
*/

"SET XFOLDERPATH=G:\develop\C\XFolder\running"

/*
    If the following variable is set to ANYTHING, the
    makefiles will produce no debug code, but code for
    the release version.
*/

"SET XFRELEASE=YES"

/* *** go! */

/* reset timer */
call time("E")
mydir = directory();

Say "***********************************************"
Say "*  Making XFolder main module (./MAIN/)...    *"
Say "***********************************************"
"cd main"
"nmake /nologo xfldr.mak"
"cd .."

Say "***********************************************"
Say "*  Making NLS files...                        *"
Say "***********************************************"
Say "   Making /001/XFLDR001.DLL"
"cd 001"
"nmake /nologo xfldr001.mak"

Say "   Making /001/INF.001/XFLDR001.INF..."
"cd inf.001"
"nmake /nologo inf001.mak"

Say "   Making /001/HELP.001/XFLDR001.HLP..."
"cd ..\help.001"
"nmake /nologo help001.mak"
"cd ..\.."

/* if you want to create new NLS files, */
/* change the following "049"'s to your */
/* language code */

/* this is for German */
LanguageDir  = "049_de"
LanguageCode = "049"

if (stream(LanguageDir"\xfldr"LanguageCode".mak", "C", "QUERY EXISTS") \= "") then
do
    Say "  Making "LanguageDir"/XFLDR"LanguageCode".DLL..."
    "cd "LanguageDir
    "copy ..\001\inf.001\vers_2history.html .\inf.049 > NUL"
    "copy ..\001\inf.001\notices_41thanks.html .\inf.049 > NUL"
    "copy ..\001\inf.001\notices_42credits.html .\inf.049 > NUL"
    /* "copy ..\001\inf.001\further*.html .\inf.049 > NUL" */
    "nmake /nologo xfldr"LanguageCode".mak"
    Say "  Making "LanguageDir"/XFLDR"LanguageCode".INF..."
    "cd inf."LanguageCode
    "nmake /nologo inf"LanguageCode".mak"
    Say "  Making "LanguageDir"/XFLDR"LanguageCode".HLP..."
    "cd ..\help."LanguageCode
    "nmake /nologo help"LanguageCode".mak"
    "cd "mydir
end;

/* this is for Spanish */

LanguageDir  = "034_es"
LanguageCode = "034"

if (stream(LanguageDir"\xfldr"LanguageCode".mak", "C", "QUERY EXISTS") \= "") then
do
    Say "  Making "LanguageDir"/XFLDR"LanguageCode".DLL..."
    "cd "LanguageDir
/*     "copy ..\001\inf.001\vers_2history.html .\inf."LanguageCode" > NUL" */
/*     "copy ..\001\inf.001\notices_41thanks.html .\inf."LanguageCode" > NUL" */
/*     "copy ..\001\inf.001\notices_42credits.html .\inf."LanguageCode" > NUL" */
/*     "copy ..\001\inf.001\further*.html .\inf."LanguageCode" > NUL" */
    "nmake /nologo xfldr"LanguageCode".mak"
/*    Say "  Making "LanguageDir"/XFLDR"LanguageCode".INF..."
     "cd inf."LanguageCode
    "nmake /nologo inf"LanguageCode".mak"
    Say "  Making "LanguageDir"/XFLDR"LanguageCode".HLP..."
    "cd ..\help."LanguageCode
    "nmake /nologo help"LanguageCode".mak" */
    "cd "mydir
end;

/* this is for Swedish */

LanguageDir  = "046_se"
LanguageCode = "046"

if (stream(LanguageDir"\xfldr"LanguageCode".mak", "C", "QUERY EXISTS") \= "") then
do
    Say "  Making "LanguageDir"/XFLDR"LanguageCode".DLL..."
    "cd "LanguageDir
/*     "copy ..\001\inf.001\vers_2history.html .\inf."LanguageCode" > NUL" */
/*     "copy ..\001\inf.001\notices_41thanks.html .\inf."LanguageCode" > NUL" */
/*     "copy ..\001\inf.001\notices_42credits.html .\inf."LanguageCode" > NUL" */
/*     "copy ..\001\inf.001\further*.html .\inf."LanguageCode" > NUL" */
    "nmake /nologo xfldr"LanguageCode".mak"
    Say "  Making "LanguageDir"/XFLDR"LanguageCode".INF..."
    "cd inf."LanguageCode
    "nmake /nologo inf"LanguageCode".mak"
    Say "  Making "LanguageDir"/XFLDR"LanguageCode".HLP..."
    "cd ..\help."LanguageCode
    "nmake /nologo help"LanguageCode".mak"
    "cd "mydir
end;

/* this is for czech */

LanguageDir  = "421_cz"
LanguageCode = "421"

if (stream(LanguageDir"\xfldr"LanguageCode".mak", "C", "QUERY EXISTS") \= "") then
do
    Say "  Making "LanguageDir"/XFLDR"LanguageCode".DLL..."
    "cd "LanguageDir
/*     "copy ..\001\inf.001\vers_2history.html .\inf."LanguageCode" > NUL" */
/*     "copy ..\001\inf.001\notices_41thanks.html .\inf."LanguageCode" > NUL" */
/*     "copy ..\001\inf.001\notices_42credits.html .\inf."LanguageCode" > NUL" */
/*     "copy ..\001\inf.001\further*.html .\inf."LanguageCode" > NUL" */
    "nmake /nologo xfldr"LanguageCode".mak"
/*    Say "  Making "LanguageDir"/XFLDR"LanguageCode".INF..."
     "cd inf."LanguageCode
    "nmake /nologo inf"LanguageCode".mak"
    Say "  Making "LanguageDir"/XFLDR"LanguageCode".HLP..."
    "cd ..\help."LanguageCode
    "nmake /nologo help"LanguageCode".mak" */
    "cd "mydir
end;

/* XFolder Programming Guide and Reference; this
   only exists on my harddisk ;-) */
if (stream("..\progref\progref.mak", "C", "QUERY EXISTS") \= "") then do
    Say "  Making ..\progref\xfsrc.mak"
    "cd ..\progref"
    "copy ..\source\001\inf.001\notices_1licence.html"
    "nmake /nologo progref.mak"
    "cd "mydir
end

/* show elapsed time */
seconds = time("e"); /* in seconds */
minutes = trunc(seconds/60);
seconds2 = trunc(seconds - (minutes*60));
Say;
Say "Done!"
Say "Elapsed time: "minutes" minutes, "seconds2" seconds."
"pause"


