/*****************************************************************************/
/* PREVWDLL.CMD                                                              */
/* Create a preview DLL for the specified icon theme.                        */
/*****************************************************************************/
SIGNAL ON NOVALUE

PARSE UPPER ARG compiler identifier iconpath

compiler   = STRIP( compiler   )
identifier = STRIP( identifier )
iconpath   = STRIP( iconpath   )
iconpath   = STRIP( iconpath, 'T', '\')

IF (( compiler \= 'GCC') & ( compiler \= 'IBM')) | ( identifier == '') THEN DO
    PARSE UPPER SOURCE . . me '.CMD' .
    myname = FILESPEC('NAME', me )
    SAY 'Syntax:' myname '<compiler> <identifier> [ <directory> ]'
    SAY
    SAY 'Where:'
    SAY '   <compiler>   = The C compiler used to create the preview DLL.  This must be'
    SAY '                  one of the following:'
    SAY '                    IBM  - IBM C/C++ compiler (ICC.EXE)'
    SAY '                    GCC  - GCC compiler (GCC.EXE)'
    SAY '                  The compiler you select must be correctly configured and '
    SAY '                  available via the system paths.'
    SAY
    SAY '   <identifier> = The theme identifier.  This must be 8 characters or less, and'
    SAY '                  contain only basic ASCII letters and numbers.'
    SAY
    SAY '   <directory>  = Path name of the directory containing icon files.  If omitted,'
    SAY '                  it is assumed to be the same as the theme identifier.'
    SAY
    RETURN 0
END
IF LENGTH( identifier ) > 8 THEN DO
    SAY 'The identifier cannot be longer than eight characters.'
    RETURN 0
END
IF iconpath = '' THEN iconpath = identifier

source_c   = identifier'.C'
source_def = identifier'.DEF'
source_rc  = identifier'.RC'
target_res = identifier'.RES'
target_obj = identifier'.OBJ'
target_dll = identifier'.DLL'

/* Compiler commands used to create the DLL from the source files: */
rc_command = 'rc -x2' source_rc target_dll
SELECT
    WHEN compiler == 'IBM' THEN
        cc_command = 'icc /Ge- /Q' source_c source_def
    OTHERWISE
        cc_command = 'gcc -Zdll -Zomf -Zsys -Zso' source_c source_def '-o' target_dll
END

/* Change to the icon directory. */
current = DIRECTORY()
IF ( DIRECTORY( iconpath ) = current ) THEN DO
    SAY 'Error: cannot change to directory' iconpath'.'
    RETURN 1
END

/* Inform the user if any of the working files already exist, just in case. */
wait = 0
IF ( STREAM( source_c,   'C', 'QUERY EXISTS') \= '') THEN DO
    SAY 'Existing' source_c 'will be overwritten.'
    wait = 1
END
IF ( STREAM( source_def, 'C', 'QUERY EXISTS') \= '') THEN DO
    SAY 'Existing' source_def 'will be overwritten.'
    wait = 1
END
IF ( STREAM( source_rc,  'C', 'QUERY EXISTS') \= '') THEN DO
    SAY 'Existing' source_rc 'will be overwritten.'
    wait = 1
END
IF ( STREAM( target_res,  'C', 'QUERY EXISTS') \= '') THEN DO
    SAY 'Existing' target_res 'will be overwritten.'
    wait = 1
END
IF ( STREAM( target_dll,  'C', 'QUERY EXISTS') \= '') THEN DO
    SAY 'Existing' target_dll 'will be overwritten.'
    wait = 1
END
IF wait = 1 THEN '@PAUSE'

SAY 'Creating preview DLL for' identifier 'using files in directory' iconpath '...'

/* Create the DLL source files. */
CALL MakeC   source_c
CALL MakeDef source_def
CALL MakeRC  source_rc

/* Compile the DLL. */
ADDRESS CMD cc_command
SAY
IF rc \= 0 THEN RETURN rc

/* Bind the resources to the DLL. */
ADDRESS CMD rc_command
SAY
IF rc \= 0 THEN RETURN rc

/* Clean up. */
IF STREAM( target_obj, 'C', 'QUERY EXISTS') \= '' THEN
    ADDRESS CMD '@erase' target_obj
IF STREAM( target_res, 'C', 'QUERY EXISTS') \= '' THEN
    ADDRESS CMD '@erase' target_res

RETURN 0



/*****************************************************************************/
MakeC: PROCEDURE EXPOSE identifier
    ARG target
    IF ( STREAM( target, 'C', 'QUERY EXISTS') \= '') THEN '@ERASE' target
    CALL LINEOUT target, '/*'
    CALL LINEOUT target, ' *' identifier'.C'
    CALL LINEOUT target, ' * Stub C file for resource DLL'
    CALL LINEOUT target, ' */'
    CALL LINEOUT target
RETURN 0


/*****************************************************************************/
MakeDef: PROCEDURE EXPOSE identifier
    ARG target
    IF ( STREAM( target, 'C', 'QUERY EXISTS') \= '') THEN '@ERASE' target
    CALL LINEOUT target, 'LIBRARY' identifier
    CALL LINEOUT target
RETURN 0


/*****************************************************************************/
MakeRC: PROCEDURE
    ARG target
    IF ( STREAM( target, 'C', 'QUERY EXISTS') \= '') THEN '@ERASE' target
    CALL LINEOUT target, 'POINTER   2 002.ICO      /* VIO window */'
    CALL LINEOUT target, 'POINTER   3 003.ICO      /* PM window  */'
    CALL LINEOUT target, 'POINTER  13 013.ICO      /* Hard disk  */'
    CALL LINEOUT target, 'POINTER  24 024.ICO      /* File       */'
    CALL LINEOUT target, 'POINTER  26 026.ICO      /* Folder     */'
    CALL LINEOUT target, 'POINTER  33 033.ICO      /* Network    */'
    CALL LINEOUT target, 'POINTER  48 048.ICO      /* Templates  */'
    CALL LINEOUT target, 'POINTER  61 061.ICO      /* System     */'
    CALL LINEOUT target, 'POINTER  92 092.ICO      /* Programs   */'
    CALL LINEOUT target, 'POINTER 119 119.ICO      /* Internet   */'
    CALL LINEOUT target
RETURN 0

