/*
 *      README.CMD - WLAN Monitor Widget Installation - Netlabs WLAN Project 2003-2008
 */
/*****************Module Header *******************************
*
* Module Name: readme.cmd
*
* Wireless LAN Status readme launch script
*
* Copyright (c) WLan Project 2003
*
* $Id: readme.cmd 1058 2013-04-29 17:39:41Z stevenhl $
*
* ===========================================================================
*
* This file is part of the WLan Project and is free software.  You can
* redistribute it and/or modify it under the terms of the GNU Library General
* Public License as published by the Free Software Foundation, in version 2
* as it comes in the "COPYING.LIB" file of the WLan Project CVS tree.
* This library is distributed in the hope that it will be useful, but WITHOUT
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
* FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
* License for more details.
*
****************************************************************************/

 PARSE SOURCE . . CallName;
 SlashPos = LASTPOS( '\', CallName);
 InfPath  = LEFT( CallName, SlashPos - 1)'\xcenter\xwlan';

 InfStem  = 'xwlan';
 DefPanel = 'Wireless';
 EnvVar   = 'XWLAN_LANGUAGE';

 /* determine panel to show */
 PARSE ARG Panel;
 IF (STRIP(Panel) = '') THEN
    Panel = DefPanel;

 /* determine filename with system language */
 /* or overridden by environment variable   */
 /* default is english language             */
 InfFile = GetInfFile( InfPath, InfStem, VALUE( EnvVar,,'OS2ENVIRONMENT'));
 IF (\FileExist( InfFile)) THEN
 DO
    InfFile = GetInfFile( InfPath, InfStem, 'eng');
    IF (\FileExist( InfFile)) THEN
    DO
       SAY 'error:' FILESPEC( 'N', InfFile) 'could not be found.';
       rc = 2; /* ERROR_FILE_NOT_FOUND */
    END;
 END;

 /* launch it */
 '@START VIEW' InfFile '"'Panel'"';

 EXIT(rc);

/* ------------------------------------------------------------------------- */
FileExist: PROCEDURE
 PARSE ARG FileName

 RETURN(STREAM(Filename, 'C', 'QUERY EXISTS') > '');

/* ========================================================================= */
GetSystemLanguage: PROCEDURE EXPOSE (GlobalVars)

 ValidLanguageChars = '0GF';
 ValidLanguageIds   = 'eng deu fra';
 SystemLanguage     = 'eng'; /* default */

 DO 1
    /* open Syslevel file and read language char */
    PARSE VALUE TRANSLATE( VALUE( 'PATH',,'OS2ENVIRONMENT')) WITH '\OS2;' -2 BootDrive +2;
    SyslevelFile = BootDrive'\OS2\INSTALL\SYSLEVEL.OS2';
    IF (STREAM( SyslevelFile, 'C', 'OPEN READ') \= 'READY:') THEN
       LEAVE;
    LanguageChar = CHARIN( SyslevelFile, X2D(37), 1);
    rcx = STREAM( SyslevelFile, 'C', 'CLOSE');

    /* translate into three letter ISO language code */
    LanguagePos = POS( LanguageChar, ValidLanguageChars);
    IF ((LanguagePos > 0) & (LanguagePos <= WORDS( ValidLanguageIds))) THEN
       SystemLanguage = WORD( ValidLanguageIds, LanguagePos);
 END;

 RETURN( SystemLanguage);

/* ========================================================================= */
GetInfFile: PROCEDURE
 PARSE ARG Path, Stem, Language;

 Language = STRIP( Language);
 IF (Language = '') THEN
    Language   = GetSystemLanguage();

 RETURN( Path'\'Stem''Language'.inf');

