{-# OPTIONS -fno-implicit-prelude #-}
-----------------------------------------------------------------------------
-- |
-- Module      :  System.Posix.Types
-- Copyright   :  (c) The University of Glasgow 2002
-- License     :  BSD-style (see the file libraries/base/LICENSE)
-- 
-- Maintainer  :  libraries@haskell.org
-- Stability   :  provisional
-- Portability :  non-portable (requires POSIX)
--
-- POSIX data types: Haskell equivalents of the types defined by the
-- @\<sys\/types.h>@ C header on a POSIX system.
--
-----------------------------------------------------------------------------









































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































module System.Posix.Types (

  -- * POSIX data types

  CDev,


  CIno,


  CMode,


  COff,


  CPid,


  CSsize,










  Fd(..),





  ByteCount,
  ClockTick,
  EpochTime,
  FileOffset,
  ProcessID,
  ProcessGroupID,
  DeviceID,
  FileID,
  FileMode,
  Limit
 ) where

import Foreign
import Foreign.C
import Data.Typeable
import Data.Bits


import Control.Monad




































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































newtype CDev = CDev Word32 deriving (Eq, Ord) ; instance Num CDev where { (CDev i) + (CDev j) = CDev (i + j) ; (CDev i) - (CDev j) = CDev (i - j) ; (CDev i) * (CDev j) = CDev (i * j) ; negate  (CDev i) = CDev (negate i) ; abs     (CDev i) = CDev (abs    i) ; signum  (CDev i) = CDev (signum i) ; fromInteger x = CDev (fromInteger x) } ; instance Read CDev where { readsPrec p s = map (\(x, t) -> (CDev x, t)) (readsPrec p s) } ; instance Show CDev where { showsPrec p (CDev x) = showsPrec p x } ; instance Enum CDev where { succ           (CDev i)             = CDev (succ i) ; pred           (CDev i)             = CDev (pred i) ; toEnum               x           = CDev (toEnum x) ; fromEnum       (CDev i)             = fromEnum i ; enumFrom       (CDev i)             = map CDev (enumFrom i) ; enumFromThen   (CDev i) (CDev j)       = map CDev (enumFromThen i j) ; enumFromTo     (CDev i) (CDev j)       = map CDev (enumFromTo i j) ; enumFromThenTo (CDev i) (CDev j) (CDev k) = map CDev (enumFromThenTo i j k) } ; instance Storable CDev where { sizeOf    (CDev x)       = sizeOf x ; alignment (CDev x)       = alignment x ; peekElemOff a i       = liftM CDev (peekElemOff (castPtr a) i) ; pokeElemOff a i (CDev x) = pokeElemOff (castPtr a) i x } ; tyConCDev = mkTyCon "CDev"; instance Typeable CDev where { typeOf _ = mkAppTy tyConCDev [] } ;


newtype CIno = CIno Int16 deriving (Eq, Ord) ; instance Num CIno where { (CIno i) + (CIno j) = CIno (i + j) ; (CIno i) - (CIno j) = CIno (i - j) ; (CIno i) * (CIno j) = CIno (i * j) ; negate  (CIno i) = CIno (negate i) ; abs     (CIno i) = CIno (abs    i) ; signum  (CIno i) = CIno (signum i) ; fromInteger x = CIno (fromInteger x) } ; instance Read CIno where { readsPrec p s = map (\(x, t) -> (CIno x, t)) (readsPrec p s) } ; instance Show CIno where { showsPrec p (CIno x) = showsPrec p x } ; instance Enum CIno where { succ           (CIno i)             = CIno (succ i) ; pred           (CIno i)             = CIno (pred i) ; toEnum               x           = CIno (toEnum x) ; fromEnum       (CIno i)             = fromEnum i ; enumFrom       (CIno i)             = map CIno (enumFrom i) ; enumFromThen   (CIno i) (CIno j)       = map CIno (enumFromThen i j) ; enumFromTo     (CIno i) (CIno j)       = map CIno (enumFromTo i j) ; enumFromThenTo (CIno i) (CIno j) (CIno k) = map CIno (enumFromThenTo i j k) } ; instance Storable CIno where { sizeOf    (CIno x)       = sizeOf x ; alignment (CIno x)       = alignment x ; peekElemOff a i       = liftM CIno (peekElemOff (castPtr a) i) ; pokeElemOff a i (CIno x) = pokeElemOff (castPtr a) i x } ; tyConCIno = mkTyCon "CIno"; instance Typeable CIno where { typeOf _ = mkAppTy tyConCIno [] } ; ; instance Bounded CIno where { minBound = CIno minBound ; maxBound = CIno maxBound } ; instance Real CIno where { toRational (CIno i) = toRational i } ; instance Integral CIno where { (CIno i) `quot`    (CIno j) = CIno (i `quot` j) ; (CIno i) `rem`     (CIno j) = CIno (i `rem`  j) ; (CIno i) `div`     (CIno j) = CIno (i `div`  j) ; (CIno i) `mod`     (CIno j) = CIno (i `mod`  j) ; (CIno i) `quotRem` (CIno j) = let (q,r) = i `quotRem` j in (CIno q, CIno r) ; (CIno i) `divMod`  (CIno j) = let (d,m) = i `divMod`  j in (CIno d, CIno m) ; toInteger (CIno i)       = toInteger i } ; instance Bits CIno where { (CIno x) .&.     (CIno y)   = CIno (x .&.   y) ; (CIno x) .|.     (CIno y)   = CIno (x .|.   y) ; (CIno x) `xor`   (CIno y)   = CIno (x `xor` y) ; complement    (CIno x)   = CIno (complement x) ; shift         (CIno x) n = CIno (shift x n) ; rotate        (CIno x) n = CIno (rotate x n) ; bit                 n = CIno (bit n) ; setBit        (CIno x) n = CIno (setBit x n) ; clearBit      (CIno x) n = CIno (clearBit x n) ; complementBit (CIno x) n = CIno (complementBit x n) ; testBit       (CIno x) n = testBit x n ; bitSize       (CIno x)   = bitSize x ; isSigned      (CIno x)   = isSigned x }


newtype CMode = CMode Word16 deriving (Eq, Ord) ; instance Num CMode where { (CMode i) + (CMode j) = CMode (i + j) ; (CMode i) - (CMode j) = CMode (i - j) ; (CMode i) * (CMode j) = CMode (i * j) ; negate  (CMode i) = CMode (negate i) ; abs     (CMode i) = CMode (abs    i) ; signum  (CMode i) = CMode (signum i) ; fromInteger x = CMode (fromInteger x) } ; instance Read CMode where { readsPrec p s = map (\(x, t) -> (CMode x, t)) (readsPrec p s) } ; instance Show CMode where { showsPrec p (CMode x) = showsPrec p x } ; instance Enum CMode where { succ           (CMode i)             = CMode (succ i) ; pred           (CMode i)             = CMode (pred i) ; toEnum               x           = CMode (toEnum x) ; fromEnum       (CMode i)             = fromEnum i ; enumFrom       (CMode i)             = map CMode (enumFrom i) ; enumFromThen   (CMode i) (CMode j)       = map CMode (enumFromThen i j) ; enumFromTo     (CMode i) (CMode j)       = map CMode (enumFromTo i j) ; enumFromThenTo (CMode i) (CMode j) (CMode k) = map CMode (enumFromThenTo i j k) } ; instance Storable CMode where { sizeOf    (CMode x)       = sizeOf x ; alignment (CMode x)       = alignment x ; peekElemOff a i       = liftM CMode (peekElemOff (castPtr a) i) ; pokeElemOff a i (CMode x) = pokeElemOff (castPtr a) i x } ; tyConCMode = mkTyCon "CMode"; instance Typeable CMode where { typeOf _ = mkAppTy tyConCMode [] } ; ; instance Bounded CMode where { minBound = CMode minBound ; maxBound = CMode maxBound } ; instance Real CMode where { toRational (CMode i) = toRational i } ; instance Integral CMode where { (CMode i) `quot`    (CMode j) = CMode (i `quot` j) ; (CMode i) `rem`     (CMode j) = CMode (i `rem`  j) ; (CMode i) `div`     (CMode j) = CMode (i `div`  j) ; (CMode i) `mod`     (CMode j) = CMode (i `mod`  j) ; (CMode i) `quotRem` (CMode j) = let (q,r) = i `quotRem` j in (CMode q, CMode r) ; (CMode i) `divMod`  (CMode j) = let (d,m) = i `divMod`  j in (CMode d, CMode m) ; toInteger (CMode i)       = toInteger i } ; instance Bits CMode where { (CMode x) .&.     (CMode y)   = CMode (x .&.   y) ; (CMode x) .|.     (CMode y)   = CMode (x .|.   y) ; (CMode x) `xor`   (CMode y)   = CMode (x `xor` y) ; complement    (CMode x)   = CMode (complement x) ; shift         (CMode x) n = CMode (shift x n) ; rotate        (CMode x) n = CMode (rotate x n) ; bit                 n = CMode (bit n) ; setBit        (CMode x) n = CMode (setBit x n) ; clearBit      (CMode x) n = CMode (clearBit x n) ; complementBit (CMode x) n = CMode (complementBit x n) ; testBit       (CMode x) n = testBit x n ; bitSize       (CMode x)   = bitSize x ; isSigned      (CMode x)   = isSigned x }


newtype COff = COff Int32 deriving (Eq, Ord) ; instance Num COff where { (COff i) + (COff j) = COff (i + j) ; (COff i) - (COff j) = COff (i - j) ; (COff i) * (COff j) = COff (i * j) ; negate  (COff i) = COff (negate i) ; abs     (COff i) = COff (abs    i) ; signum  (COff i) = COff (signum i) ; fromInteger x = COff (fromInteger x) } ; instance Read COff where { readsPrec p s = map (\(x, t) -> (COff x, t)) (readsPrec p s) } ; instance Show COff where { showsPrec p (COff x) = showsPrec p x } ; instance Enum COff where { succ           (COff i)             = COff (succ i) ; pred           (COff i)             = COff (pred i) ; toEnum               x           = COff (toEnum x) ; fromEnum       (COff i)             = fromEnum i ; enumFrom       (COff i)             = map COff (enumFrom i) ; enumFromThen   (COff i) (COff j)       = map COff (enumFromThen i j) ; enumFromTo     (COff i) (COff j)       = map COff (enumFromTo i j) ; enumFromThenTo (COff i) (COff j) (COff k) = map COff (enumFromThenTo i j k) } ; instance Storable COff where { sizeOf    (COff x)       = sizeOf x ; alignment (COff x)       = alignment x ; peekElemOff a i       = liftM COff (peekElemOff (castPtr a) i) ; pokeElemOff a i (COff x) = pokeElemOff (castPtr a) i x } ; tyConCOff = mkTyCon "COff"; instance Typeable COff where { typeOf _ = mkAppTy tyConCOff [] } ; ; instance Bounded COff where { minBound = COff minBound ; maxBound = COff maxBound } ; instance Real COff where { toRational (COff i) = toRational i } ; instance Integral COff where { (COff i) `quot`    (COff j) = COff (i `quot` j) ; (COff i) `rem`     (COff j) = COff (i `rem`  j) ; (COff i) `div`     (COff j) = COff (i `div`  j) ; (COff i) `mod`     (COff j) = COff (i `mod`  j) ; (COff i) `quotRem` (COff j) = let (q,r) = i `quotRem` j in (COff q, COff r) ; (COff i) `divMod`  (COff j) = let (d,m) = i `divMod`  j in (COff d, COff m) ; toInteger (COff i)       = toInteger i } ; instance Bits COff where { (COff x) .&.     (COff y)   = COff (x .&.   y) ; (COff x) .|.     (COff y)   = COff (x .|.   y) ; (COff x) `xor`   (COff y)   = COff (x `xor` y) ; complement    (COff x)   = COff (complement x) ; shift         (COff x) n = COff (shift x n) ; rotate        (COff x) n = COff (rotate x n) ; bit                 n = COff (bit n) ; setBit        (COff x) n = COff (setBit x n) ; clearBit      (COff x) n = COff (clearBit x n) ; complementBit (COff x) n = COff (complementBit x n) ; testBit       (COff x) n = testBit x n ; bitSize       (COff x)   = bitSize x ; isSigned      (COff x)   = isSigned x }


newtype CPid = CPid Int32 deriving (Eq, Ord) ; instance Num CPid where { (CPid i) + (CPid j) = CPid (i + j) ; (CPid i) - (CPid j) = CPid (i - j) ; (CPid i) * (CPid j) = CPid (i * j) ; negate  (CPid i) = CPid (negate i) ; abs     (CPid i) = CPid (abs    i) ; signum  (CPid i) = CPid (signum i) ; fromInteger x = CPid (fromInteger x) } ; instance Read CPid where { readsPrec p s = map (\(x, t) -> (CPid x, t)) (readsPrec p s) } ; instance Show CPid where { showsPrec p (CPid x) = showsPrec p x } ; instance Enum CPid where { succ           (CPid i)             = CPid (succ i) ; pred           (CPid i)             = CPid (pred i) ; toEnum               x           = CPid (toEnum x) ; fromEnum       (CPid i)             = fromEnum i ; enumFrom       (CPid i)             = map CPid (enumFrom i) ; enumFromThen   (CPid i) (CPid j)       = map CPid (enumFromThen i j) ; enumFromTo     (CPid i) (CPid j)       = map CPid (enumFromTo i j) ; enumFromThenTo (CPid i) (CPid j) (CPid k) = map CPid (enumFromThenTo i j k) } ; instance Storable CPid where { sizeOf    (CPid x)       = sizeOf x ; alignment (CPid x)       = alignment x ; peekElemOff a i       = liftM CPid (peekElemOff (castPtr a) i) ; pokeElemOff a i (CPid x) = pokeElemOff (castPtr a) i x } ; tyConCPid = mkTyCon "CPid"; instance Typeable CPid where { typeOf _ = mkAppTy tyConCPid [] } ; ; instance Bounded CPid where { minBound = CPid minBound ; maxBound = CPid maxBound } ; instance Real CPid where { toRational (CPid i) = toRational i } ; instance Integral CPid where { (CPid i) `quot`    (CPid j) = CPid (i `quot` j) ; (CPid i) `rem`     (CPid j) = CPid (i `rem`  j) ; (CPid i) `div`     (CPid j) = CPid (i `div`  j) ; (CPid i) `mod`     (CPid j) = CPid (i `mod`  j) ; (CPid i) `quotRem` (CPid j) = let (q,r) = i `quotRem` j in (CPid q, CPid r) ; (CPid i) `divMod`  (CPid j) = let (d,m) = i `divMod`  j in (CPid d, CPid m) ; toInteger (CPid i)       = toInteger i } ; instance Bits CPid where { (CPid x) .&.     (CPid y)   = CPid (x .&.   y) ; (CPid x) .|.     (CPid y)   = CPid (x .|.   y) ; (CPid x) `xor`   (CPid y)   = CPid (x `xor` y) ; complement    (CPid x)   = CPid (complement x) ; shift         (CPid x) n = CPid (shift x n) ; rotate        (CPid x) n = CPid (rotate x n) ; bit                 n = CPid (bit n) ; setBit        (CPid x) n = CPid (setBit x n) ; clearBit      (CPid x) n = CPid (clearBit x n) ; complementBit (CPid x) n = CPid (complementBit x n) ; testBit       (CPid x) n = testBit x n ; bitSize       (CPid x)   = bitSize x ; isSigned      (CPid x)   = isSigned x }



newtype CSsize = CSsize Word32 deriving (Eq, Ord) ; instance Num CSsize where { (CSsize i) + (CSsize j) = CSsize (i + j) ; (CSsize i) - (CSsize j) = CSsize (i - j) ; (CSsize i) * (CSsize j) = CSsize (i * j) ; negate  (CSsize i) = CSsize (negate i) ; abs     (CSsize i) = CSsize (abs    i) ; signum  (CSsize i) = CSsize (signum i) ; fromInteger x = CSsize (fromInteger x) } ; instance Read CSsize where { readsPrec p s = map (\(x, t) -> (CSsize x, t)) (readsPrec p s) } ; instance Show CSsize where { showsPrec p (CSsize x) = showsPrec p x } ; instance Enum CSsize where { succ           (CSsize i)             = CSsize (succ i) ; pred           (CSsize i)             = CSsize (pred i) ; toEnum               x           = CSsize (toEnum x) ; fromEnum       (CSsize i)             = fromEnum i ; enumFrom       (CSsize i)             = map CSsize (enumFrom i) ; enumFromThen   (CSsize i) (CSsize j)       = map CSsize (enumFromThen i j) ; enumFromTo     (CSsize i) (CSsize j)       = map CSsize (enumFromTo i j) ; enumFromThenTo (CSsize i) (CSsize j) (CSsize k) = map CSsize (enumFromThenTo i j k) } ; instance Storable CSsize where { sizeOf    (CSsize x)       = sizeOf x ; alignment (CSsize x)       = alignment x ; peekElemOff a i       = liftM CSsize (peekElemOff (castPtr a) i) ; pokeElemOff a i (CSsize x) = pokeElemOff (castPtr a) i x } ; tyConCSsize = mkTyCon "CSsize"; instance Typeable CSsize where { typeOf _ = mkAppTy tyConCSsize [] } ; ; instance Bounded CSsize where { minBound = CSsize minBound ; maxBound = CSsize maxBound } ; instance Real CSsize where { toRational (CSsize i) = toRational i } ; instance Integral CSsize where { (CSsize i) `quot`    (CSsize j) = CSsize (i `quot` j) ; (CSsize i) `rem`     (CSsize j) = CSsize (i `rem`  j) ; (CSsize i) `div`     (CSsize j) = CSsize (i `div`  j) ; (CSsize i) `mod`     (CSsize j) = CSsize (i `mod`  j) ; (CSsize i) `quotRem` (CSsize j) = let (q,r) = i `quotRem` j in (CSsize q, CSsize r) ; (CSsize i) `divMod`  (CSsize j) = let (d,m) = i `divMod`  j in (CSsize d, CSsize m) ; toInteger (CSsize i)       = toInteger i } ; instance Bits CSsize where { (CSsize x) .&.     (CSsize y)   = CSsize (x .&.   y) ; (CSsize x) .|.     (CSsize y)   = CSsize (x .|.   y) ; (CSsize x) `xor`   (CSsize y)   = CSsize (x `xor` y) ; complement    (CSsize x)   = CSsize (complement x) ; shift         (CSsize x) n = CSsize (shift x n) ; rotate        (CSsize x) n = CSsize (rotate x n) ; bit                 n = CSsize (bit n) ; setBit        (CSsize x) n = CSsize (setBit x n) ; clearBit      (CSsize x) n = CSsize (clearBit x n) ; complementBit (CSsize x) n = CSsize (complementBit x n) ; testBit       (CSsize x) n = testBit x n ; bitSize       (CSsize x)   = bitSize x ; isSigned      (CSsize x)   = isSigned x }













-- ToDo: blksize_t, clockid_t, blkcnt_t, fsblkcnt_t, fsfilcnt_t, id_t, key_t
-- suseconds_t, timer_t, useconds_t

-- Make an Fd type rather than using CInt everywhere
newtype Fd = Fd CInt deriving (Eq, Ord) ; instance Num Fd where { (Fd i) + (Fd j) = Fd (i + j) ; (Fd i) - (Fd j) = Fd (i - j) ; (Fd i) * (Fd j) = Fd (i * j) ; negate  (Fd i) = Fd (negate i) ; abs     (Fd i) = Fd (abs    i) ; signum  (Fd i) = Fd (signum i) ; fromInteger x = Fd (fromInteger x) } ; instance Read Fd where { readsPrec p s = map (\(x, t) -> (Fd x, t)) (readsPrec p s) } ; instance Show Fd where { showsPrec p (Fd x) = showsPrec p x } ; instance Enum Fd where { succ           (Fd i)             = Fd (succ i) ; pred           (Fd i)             = Fd (pred i) ; toEnum               x           = Fd (toEnum x) ; fromEnum       (Fd i)             = fromEnum i ; enumFrom       (Fd i)             = map Fd (enumFrom i) ; enumFromThen   (Fd i) (Fd j)       = map Fd (enumFromThen i j) ; enumFromTo     (Fd i) (Fd j)       = map Fd (enumFromTo i j) ; enumFromThenTo (Fd i) (Fd j) (Fd k) = map Fd (enumFromThenTo i j k) } ; instance Storable Fd where { sizeOf    (Fd x)       = sizeOf x ; alignment (Fd x)       = alignment x ; peekElemOff a i       = liftM Fd (peekElemOff (castPtr a) i) ; pokeElemOff a i (Fd x) = pokeElemOff (castPtr a) i x } ; tyConFd = mkTyCon "Fd"; instance Typeable Fd where { typeOf _ = mkAppTy tyConFd [] } ; ; instance Bounded Fd where { minBound = Fd minBound ; maxBound = Fd maxBound } ; instance Real Fd where { toRational (Fd i) = toRational i } ; instance Integral Fd where { (Fd i) `quot`    (Fd j) = Fd (i `quot` j) ; (Fd i) `rem`     (Fd j) = Fd (i `rem`  j) ; (Fd i) `div`     (Fd j) = Fd (i `div`  j) ; (Fd i) `mod`     (Fd j) = Fd (i `mod`  j) ; (Fd i) `quotRem` (Fd j) = let (q,r) = i `quotRem` j in (Fd q, Fd r) ; (Fd i) `divMod`  (Fd j) = let (d,m) = i `divMod`  j in (Fd d, Fd m) ; toInteger (Fd i)       = toInteger i } ; instance Bits Fd where { (Fd x) .&.     (Fd y)   = Fd (x .&.   y) ; (Fd x) .|.     (Fd y)   = Fd (x .|.   y) ; (Fd x) `xor`   (Fd y)   = Fd (x `xor` y) ; complement    (Fd x)   = Fd (complement x) ; shift         (Fd x) n = Fd (shift x n) ; rotate        (Fd x) n = Fd (rotate x n) ; bit                 n = Fd (bit n) ; setBit        (Fd x) n = Fd (setBit x n) ; clearBit      (Fd x) n = Fd (clearBit x n) ; complementBit (Fd x) n = Fd (complementBit x n) ; testBit       (Fd x) n = testBit x n ; bitSize       (Fd x)   = bitSize x ; isSigned      (Fd x)   = isSigned x }

-- nicer names, and backwards compatibility with POSIX library:




type ByteCount      = CSize
type ClockTick      = CClock
type EpochTime      = CTime
type DeviceID       = CDev
type FileID         = CIno
type FileMode       = CMode
type ProcessID      = CPid
type FileOffset     = COff
type ProcessGroupID = CPid
type Limit	    = CLong

